/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

import javax.xml.registry.JAXRException;


/**
 * A predicate for searching associations by target.
 */
public class AssociationTypePredicate implements FilterPredicate {
    private final Collection<?> keys;

    /**
     * Creates a new instance with the target key.
     */
    public AssociationTypePredicate(Collection<?> pKeys) {
        assert(pKeys != null);
        keys = pKeys;
    }

    @Override
    public void add(StringBuilder pBuffer, List<Object> pParameters) throws SQLException, JAXRException {
        if (keys.size() == 1) {
            final Object o = keys.iterator().next();
            pBuffer.append("assoc.roKeyType=?"); //$NON-NLS-1$
            pParameters.add(o);
        } else {
            pBuffer.append("("); //$NON-NLS-1$
            boolean first = true;
            for (Object o : keys) {
                if (first) {
                    first = false;
                } else {
                    pBuffer.append(" OR "); //$NON-NLS-1$
                }
                pBuffer.append("assoc.roKeyType=?"); //$NON-NLS-1$
                pParameters.add(o);
            }
            pBuffer.append(")"); //$NON-NLS-1$
        }
    }
}
