package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;
import java.util.List;

import javax.xml.registry.JAXRException;


/**
 * An "ORDER BY" predicate, which requests ordering by the
 * classifications number.
 */
public class ClassificationNumOrderPredicate implements OrderPredicate {
	private static final ClassificationNumOrderPredicate theInstance = new ClassificationNumOrderPredicate();

	/**
	 * Returns the singleton instance.
	 */
	public static ClassificationNumOrderPredicate getInstance() {
		return theInstance;
	}
	/**
	 * Private constructor, to ensure singleton pattern.
	 */
	private ClassificationNumOrderPredicate() {
		// Does nothing
	}

	@Override
	public void add(StringBuilder pBuffer, List<Object> pParameters)
			throws SQLException, JAXRException {
		pBuffer.append("cl.num"); //$NON-NLS-1$
	}
}
