/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.Connection;
import java.sql.SQLException;

import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;

import org.apache.labs.jaxmas.registry.infomodel.ConnectionImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;


/**
 * Implementation of {@link DbDriver} for Apache Derby.
 */
public class DerbyDbDriver extends AbstractDbDriver {
	/**
	 * Creates a new instance.
	 */
	public DerbyDbDriver(RegistryService pRegistryService) {
		super(pRegistryService);
	}

	@Override
	public void shutdown() throws JAXRException {
	    try {
	        final RegistryServiceImpl rs = (RegistryServiceImpl) getRegistryService();
	        if (rs != null) {
	            final ConnectionImpl connImpl = rs.getConnection();
	            if (connImpl != null) {
	                final Connection conn = connImpl.getConnection();
	                if (conn != null) {
	                    conn.close();
	                }
	            }
	        }
	    } catch (SQLException e) {
	        throw new JAXRException(e);
	    }
	}

    @Override
    public boolean isUnknownTableError(SQLException pException) {
    	return "42X05".equals(pException.getSQLState()) //$NON-NLS-1$
    	  ||   "42Y55".equals(pException.getSQLState()); //$NON-NLS-1$
    }

    @Override
    public String getDbProperty(String pProperty) {
        if ("CLOB".equals(pProperty)) { //$NON-NLS-1$
            return pProperty;
        }
        throw new IllegalArgumentException("Unknown property name: " + pProperty); //$NON-NLS-1$
    }
}
