/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;

import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;


/**
 * Implementation of {@link DbDriver} for HsqlDb.
 */
public class HsqlDbDriver extends AbstractDbDriver {
	/**
	 * Creates a new instance.
	 */
	public HsqlDbDriver(RegistryService pRegistryService) {
		super(pRegistryService);
	}

	@Override
	public void shutdown() throws JAXRException {
	    final String s = "SHUTDOWN"; //$NON-NLS-1$
	    Sql.run(getRegistryService(), s);
	}

    @Override
    public boolean isUnknownTableError(SQLException pException) {
        if ("S0002".equals(pException.getSQLState())  &&  pException.getErrorCode() == -22) { // HsqlDb 1
            return true;
        }
        if ("S1000".equals(pException.getSQLState())  &&  pException.getErrorCode() == -35) { // HsqlDb 1
        	return true;
        }
        if ("42501".equals(pException.getSQLState())  &&  pException.getErrorCode() == -5501) { // HsqlDb 2
            return true;
        }
        return false;
    }

    @Override
    public String getDbProperty(String pProperty) {
        if ("CLOB".equals(pProperty)) { //$NON-NLS-1$
            return "LONGVARCHAR"; //$NON-NLS-1$
        }
        throw new IllegalArgumentException("Unknown property name: " + pProperty); //$NON-NLS-1$
    }
}
