/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

import javax.xml.registry.JAXRException;


/**
 * A predicate for the registry objects key.
 */
public class KeyPredicate implements FilterPredicate {
    private final Collection<?> keys;

    /**
     * Creates a new instance with the given keys.
     */
    public KeyPredicate(Collection<?> pKeys) {
        keys = pKeys;
    }

    @Override
    public void add(StringBuilder pBuffer, List<Object> pParameters)
            throws SQLException, JAXRException {
        if (keys == null  ||  keys.size() == 0) {
            pBuffer.append("1=1"); //$NON-NLS-1$
            return;
        }
        if (keys.size() == 1) {
            pBuffer.append("ro.roKey=?"); //$NON-NLS-1$
            pParameters.add(keys.iterator().next());
        } else {
            pBuffer.append("ro.roKey IN ("); //$NON-NLS-1$
            boolean first = true;
            for (Object o : keys) {
                if (first) {
                    first = false;
                    pBuffer.append("?"); //$NON-NLS-1$
                } else {
                    pBuffer.append(",?"); //$NON-NLS-1$
                }
                pParameters.add(o);
            }
            pBuffer.append(")"); //$NON-NLS-1$
        }
    }
}
