/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

import javax.xml.registry.JAXRException;

import org.apache.labs.jaxmas.registry.infomodel.InternationalStringImpl;


/**
 * A predicate for the registry objects name.
 */
public class NamePredicate implements FilterPredicate {
    private final Collection<String> namePatterns;

    /**
     * Creates a new instance with the given name patterns.
     */
    public NamePredicate(Collection<String> pNamePatterns) {
        namePatterns = pNamePatterns;
    }

    @Override
    public void add(StringBuilder pBuffer, List<Object> pParameters)
            throws SQLException, JAXRException {
        if (namePatterns == null  ||  namePatterns.size() == 0) {
            pBuffer.append("1=1"); //$NON-NLS-1$
            return;
        }
        pBuffer.append("ro.roKey IN (SELECT roKey FROM LocalizedStrings WHERE lsType="); //$NON-NLS-1$
        pBuffer.append(InternationalStringImpl.Type.name.ordinal());
        if (pParameters.size() == 1) {
            pBuffer.append(" AND val LIKE ?"); //$NON-NLS-1$
            pParameters.add(namePatterns.iterator().next());
        } else {
            pBuffer.append(" AND ("); //$NON-NLS-1$
            boolean first = true;
            for (String namePattern : namePatterns) {
                if (first) {
                    first = false;
                } else {
                    pBuffer.append(" OR "); //$NON-NLS-1$
                }
                pBuffer.append("val LIKE ?"); //$NON-NLS-1$
                pParameters.add(namePattern);
            }
            pBuffer.append(")"); //$NON-NLS-1$
        }
        pBuffer.append(")"); //$NON-NLS-1$
    }
}
