/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.sql;



/**
 * Implementation of {@link StmtUser} for database operations,
 * which perform no result, or an object valued result.
 */
public abstract class ObjStmtUser extends StmtUser<Object> {
    /**
     * Creates a new instance with the given statement and parameters.
     */
    public ObjStmtUser(String pStatement, Object... pParams) {
		super(pStatement, pParams);
	}

    /**
     * Creates a new instance with the given statement and no parameters.
     */
	public ObjStmtUser(String pStatement) {
		super(pStatement);
	}
}
