/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;
import java.util.List;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;


/**
 * A predicate for the objects owner.
 */
public class OwnerPredicate implements FilterPredicate {
    private final Object key;
    private final boolean restricting;

    /**
     * Creates a new instance with the given owners key.
     */
    public OwnerPredicate(Key pKey, boolean pRestricting) {
        assert(pKey != null);
        key = pKey;
        restricting = pRestricting;
    }

    /**
     * Creates a new instance with the given owners key.
     */
    public OwnerPredicate(String pKey, boolean pRestricting) {
        assert(pKey != null);
        key = pKey;
        restricting = pRestricting;
    }

    @Override
    public void add(StringBuilder pBuffer, List<Object> pParameters) throws SQLException, JAXRException {
    	if (restricting) {
    		pBuffer.append("ro.roOwnerRestricting=?"); //$NON-NLS-1$
    	} else {
    		pBuffer.append("ro.roOwnerCascading=?"); //$NON-NLS-1$
    	}
        pParameters.add(key);
    }
}
