/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.xml.registry.JAXRException;


/**
 * Extension of {@link StmtUser} for database operations, which are
 * reading a query result.
 */
public abstract class QueryUser<O extends Object> extends StmtUser<O> {
	/**
	 * Creates a new instance, which performs the given statement
	 * using the given parameters.
	 */
	public QueryUser(String pStatement, Object... pParams) {
		super(pStatement, pParams);
	}

	/**
	 * Immplemented by the concrete subclass for actually reading the
	 * query result.
	 */
	protected abstract void action(ResultSet pResultSet) throws JAXRException, SQLException;

	@Override
	protected void action(PreparedStatement pStatement) throws JAXRException, SQLException {
		ResultSet rs = pStatement.executeQuery();
		try {
			action(rs);
			rs.close();
			rs = null;
		} finally {
			if (rs != null) { try { rs.close(); } catch (Throwable t) { /* Ignore me */ } }
		}
	}
}
