/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;
import java.util.List;

import javax.xml.registry.JAXRException;

import org.apache.labs.jaxmas.registry.accessor.ROAccessors;


/**
 * Predicate for restricting a search to a particular registry object type.
 */
public class RegistryObjectTypePredicate implements FilterPredicate {
    private final String prefix;
    private final ROAccessors.ObjectTypes type;

    /**
     * Creates a new instance, which restricts the search to the given
     * type.
     */
    public RegistryObjectTypePredicate(ROAccessors.ObjectTypes pType) {
        this(pType, null);
    }

    /**
     * Creates a new instance, which restricts the search to the given
     * type.
     */
    public RegistryObjectTypePredicate(ROAccessors.ObjectTypes pType, String pPrefix) {
        prefix = pPrefix;
        type = pType;
    }

    /**
     * Returns the object type.
     */
    public ROAccessors.ObjectTypes getType() {
        return type;
    }

    @Override
    public void add(StringBuilder pBuffer, List<Object> pParameters) throws SQLException, JAXRException {
        final String roTable = RegistryObjectLoader.getRoTable(prefix);
        pBuffer.append(roTable);
        pBuffer.append(".roType=");
        pBuffer.append(type.ordinal());
    }

}
