package org.apache.labs.jaxmas.registry.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.RegistryObject;

import org.apache.labs.jaxmas.registry.accessor.ROAccessors;

/**
 * Extension handlers are used for type specific extension tables.
 */
public abstract class TableHandler {
    private final ROAccessors.ObjectTypes objectType;

    /**
     * Creates a new instance with the given object type.
     */
    public TableHandler(ROAccessors.ObjectTypes pObjectType) {
        objectType = pObjectType;
    }

    /**
     * Returns the extension handlers object type. May be null, if the
     * object type is not specified.
     */
    protected ROAccessors.ObjectTypes getObjectType() {
        return objectType;
    }

    /**
     * Called to extend the column list of the SQL query for reading registry objects.
     */
    protected abstract int addColumns(StringBuilder pBuilder, String pPrefix, int pIndex);
    /**
     * Called to extend the FROM clause of the SQL query for reading registry objects.
     */
    protected abstract void addJoin(StringBuilder pBuilder, String pPrefix, List<?> pParameters);
    /**
     * Called to pull data from the result set when reading registry objects.
     */
    protected abstract int load(ResultSet pResultSet, RegistryObject pRegistryObject, int pIndex)
        throws SQLException, JAXRException;
}