/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.util;


/**
 * This is the default logger factory, which is used only,
 * if log4j is not available.
 */
public class DefaultLoggerFactory implements LoggerFactory {
	private static LoggerFactory theInstance;

	static {
		LoggerFactory lf;
		try {
			lf = new Log4jLoggerFactory();
		} catch (Throwable t) {
			lf = new DefaultLoggerFactory();
		}
		theInstance = lf;
	}

	/**
	 * Returns the current logger factory.
	 */
	public static synchronized LoggerFactory getInstance() {
		return theInstance;
	}

	/**
	 * Sets the current logger factory.
	 */
	public static synchronized void setLoggerFactory(LoggerFactory pFactory) {
	    theInstance = pFactory;
	}

	private int level = DefaultLogger.LEVEL_DEBUG;

	@Override
	public Logger newLogger(Class<?> pClass) {
		return new DefaultLogger(pClass, level);
	}

	@Override
	public Logger newLogger(String pId) {
		return new DefaultLogger(pId, level);
	}

	/**
	 * Returns the factories log level, which is used to create new loggers.
	 */
	public int getLevel() {
		return level;
	}

    /**
     * Sets the factories log level, which is used to create new loggers.
     */
	public void setLevel(int pLevel) {
		level = pLevel;
	}
}
