/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.util;

import java.util.Locale;
import java.util.StringTokenizer;

/**
 * Utility class for working with calendars.
 */
public class Locales {
	/**
	 * Private constructor, to prevent accidental instantiation.
	 */
	private Locales() {
		// Does nothing
	}

	/**
	 * Returns the locale with the given identifier.
	 */
	public static Locale getLocale(String localeProperty) {
		try {
			final StringTokenizer st = new StringTokenizer(localeProperty, "_"); //$NON-NLS-1$
			if (st.hasMoreTokens()) {
				final String lang = st.nextToken();
				if (st.hasMoreTokens()) {
					final String country = st.nextToken();
					if (st.hasMoreTokens()) {
						final String variant = st.nextToken();
						return new Locale(lang, country, variant);
					}
					return new Locale(lang, country);
				}
				return new Locale(lang);
			}
		} catch (Throwable t) {
			// Ignore me, use the default locale
		}
		return Locale.getDefault();
	}
}
