/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.util;

import java.net.URL;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;


/**
 * Default implementation of {@link LoggerFactory}.
 */
public class Log4jLoggerFactory implements LoggerFactory {
	/**
	 * Creates a new instance with default settings.
	 */
	public Log4jLoggerFactory() {
		final URL url = Thread.currentThread().getContextClassLoader().getResource("log4j.properties"); //$NON-NLS-1$
		if (url == null) {
			if (!org.apache.log4j.Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
				BasicConfigurator.configure();
			}
		} else {
			if ("file".equals(url.getProtocol())) { //$NON-NLS-1$
				PropertyConfigurator.configureAndWatch(url.getFile());
			} else {
				PropertyConfigurator.configure(url);
			}
		}
	}

	@Override
	public Logger newLogger(Class<?> pClass) {
		return new Log4jLogger(pClass);
	}

	@Override
	public Logger newLogger(String pId) {
		return new Log4jLogger(pId);
	}
}
