/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.util;


/**
 * Utility class for working with strings.
 */
public class Strings {
	/**
	 * Private constructor, to prevent accidental instantiation
	 */
	private Strings() {
		// Does nothing
	}

	/**
	 * Returns, whether the given string is null or empty.
	 */
	public static boolean isEmpty(String pValue) {
		return pValue == null  ||  pValue.length() == 0;
	}

	/**
	 * Returns, whether the given string is null or empty after trimming.
	 */
	public static boolean isTrimmedEmpty(String pValue) {
		return pValue == null  ||  pValue.trim().length() == 0;
	}
}
