/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry;

import javax.xml.registry.BulkResponse;
import javax.xml.registry.Connection;
import javax.xml.registry.infomodel.ClassificationScheme;

import org.junit.Test;
import static org.junit.Assert.*;


/**
 * Test case for initializing the database.
 */
public class DbInitializationTest extends AbstractJaxMasTestCase {
    /**
	 * Initializes the database.
	 */
	@Test public void testInitDatabase() throws Exception {
		super.initDatabase();
	}

	/**
	 * Test loading the classification schemes.
	 */
	@Test public void testLoadClassificationSchemes() throws Exception {
		Connection connection = newConnection();
		final BulkResponse br = connection.getRegistryService().getBusinessQueryManager().findClassificationSchemes(null, null, null, null);
		boolean objectTypesFound = false;
		boolean associationTypesFound = false;
		for (Object o : br.getCollection()) {
			final ClassificationScheme cs = (ClassificationScheme) o;
            final String usName = asString(cs.getName());
			if ("ObjectType".equals(usName)) { //$NON-NLS-1$
				objectTypesFound = true;
			} else if ("AssociationType".equals(usName)) { //$NON-NLS-1$
				associationTypesFound = true;
			}
		}
		assertTrue(objectTypesFound);
		assertTrue(associationTypesFound);
	}
}
