package org.apache.labs.jaxmas.registry;

import java.util.Collection;
import java.util.Collections;

import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.FindQualifier;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Organization;

import junit.framework.Assert;

import org.junit.Test;


/**
 * Test case for handling of organizations.
 */
public class OrganizationTestCase extends AbstractJaxMasTestCase {
	private Organization findOrganization(BusinessQueryManager pBqm, String pName) throws JAXRException {
		final BulkResponse br = pBqm.findOrganizations(Collections.singleton(FindQualifier.EXACT_NAME_MATCH),
				Collections.singleton(pName), null, null, null, null);
		final Collection<?> list = br.getCollection();
		return (Organization) (list.isEmpty() ? null : list.iterator().next());
	}

	/**
	 * Tests creating and deleting an organization.
	 */
	@Test public void testCreateOrganization() throws Exception {
		final String name = OrganizationTestCase.class.getName() + System.currentTimeMillis();
		Connection conn = newConnection();
		try {
			RegistryService service = conn.getRegistryService();
			Organization org = findOrganization(service.getBusinessQueryManager(), name);
			Assert.assertNull(org);
			org = service.getBusinessLifeCycleManager().createOrganization(name);
			Assert.assertNotNull(org);
			service.getBusinessLifeCycleManager().saveOrganizations(Collections.singleton(org));
			conn.close();
			conn = null;
			conn = newConnection();
			service = conn.getRegistryService();
			org = findOrganization(service.getBusinessQueryManager(), name);
			Assert.assertNotNull(org);
			service.getBusinessLifeCycleManager().deleteOrganizations(Collections.singleton(org.getKey()));
			org = findOrganization(service.getBusinessQueryManager(), name);
			Assert.assertNull(org);
			conn.close();
			conn = null;
		} finally {
			if (conn != null) { try { conn.close(); } catch (Throwable t) { /* Ignore me */ } }
		}
	}
}
