/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.schema;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

import org.apache.labs.jaxmas.registry.schema.MacroProcessor;
import org.junit.Test;

import junit.framework.TestCase;


/**
 * Test case for the {@link MacroProcessor}.
 */
public class MacroProcessorTest extends TestCase {
    private static final String document =
        "&{macro, Taxonomy,\n" //$NON-NLS-1$
        + "    'INSERT INTO RegistryObjects (roKey, pos, roType) VALUES (\\1, \\0, 7)',\n" //$NON-NLS-1$
        + "    'INSERT INTO RegistryEntries (roKey, majorVersion, minorVersion, userVersion) VALUES (\\1, 1, 0, \\'1.0\\')',\n" //$NON-NLS-1$
        + "    'INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES (\\1, 0, \\'en\\', \\'UTF-8\\', \\2)',\n" //$NON-NLS-1$
        + "    'INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES (\\1, 1, \\'en\\', \\'UTF-8\\', \\3)'\n" //$NON-NLS-1$
        + "}\n" //$NON-NLS-1$
        + "&{macro, Concept,\n" //$NON-NLS-1$
        + "    'INSERT INTO RegistryObjects (roKey, roOwnerRestricting, pos, roType) VALUES (\\1, \\2, \\0, 10)',\n" //$NON-NLS-1$
        + "    'INSERT INTO Concepts (roKey, value) VALUES (\\1, \\3)',\n" //$NON-NLS-1$
        + "    'INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES (\\1, 0, \\'en\\', \\'UTF-8\\', \\3)'\n" //$NON-NLS-1$
        + "}\n" //$NON-NLS-1$
        + "&{Taxonomy, 0, '00000000000000000000000000000001', 'ObjectType', 'The taxonomy of object types. Object types are categories below this taxonomy.'}\n" //$NON-NLS-1$
        + "&{Taxonomy, 1, '00000000000000000000000000000002', 'AssociationType', 'The taxonomy of association types. Association types are categories below this taxonomy.'}\n" //$NON-NLS-1$
        + "\n" //$NON-NLS-1$
        + "&{Concept, 0, '00000000000000000000000000000003', '00000000000000000000000000000001', 'Association'}\n" //$NON-NLS-1$
        + "&{Concept, 1, '00000000000000000000000000000004', '00000000000000000000000000000001', 'AuditableEvent'}\n" //$NON-NLS-1$
        + "&{Concept, 2, '00000000000000000000000000000005', '00000000000000000000000000000001', 'Classification'}\n"; //$NON-NLS-1$

    private static final String processedDocument =
        "\n" //$NON-NLS-1$
        + "\n" //$NON-NLS-1$
        + "INSERT INTO RegistryObjects (roKey, pos, roType) VALUES ('00000000000000000000000000000001', 0, 7);\n" //$NON-NLS-1$
        + "INSERT INTO RegistryEntries (roKey, majorVersion, minorVersion, userVersion) VALUES ('00000000000000000000000000000001', 1, 0, '1.0');\n" //$NON-NLS-1$
        + "INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES ('00000000000000000000000000000001', 0, 'en', 'UTF-8', 'ObjectType');\n" //$NON-NLS-1$
        + "INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES ('00000000000000000000000000000001', 1, 'en', 'UTF-8', 'The taxonomy of object types. Object types are categories below this taxonomy.');\n" //$NON-NLS-1$
        + "\n" //$NON-NLS-1$
        + "INSERT INTO RegistryObjects (roKey, pos, roType) VALUES ('00000000000000000000000000000002', 1, 7);\n" //$NON-NLS-1$
        + "INSERT INTO RegistryEntries (roKey, majorVersion, minorVersion, userVersion) VALUES ('00000000000000000000000000000002', 1, 0, '1.0');\n" //$NON-NLS-1$
        + "INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES ('00000000000000000000000000000002', 0, 'en', 'UTF-8', 'AssociationType');\n" //$NON-NLS-1$
        + "INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES ('00000000000000000000000000000002', 1, 'en', 'UTF-8', 'The taxonomy of association types. Association types are categories below this taxonomy.');\n" //$NON-NLS-1$
        + "\n" //$NON-NLS-1$
        + "\n" //$NON-NLS-1$
        + "INSERT INTO RegistryObjects (roKey, roOwnerRestricting, pos, roType) VALUES ('00000000000000000000000000000003', '00000000000000000000000000000001', 0, 10);\n" //$NON-NLS-1$
        + "INSERT INTO Concepts (roKey, value) VALUES ('00000000000000000000000000000003', 'Association');\n" //$NON-NLS-1$
        + "INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES ('00000000000000000000000000000003', 0, 'en', 'UTF-8', 'Association');\n" //$NON-NLS-1$
        + "\n" //$NON-NLS-1$
        + "INSERT INTO RegistryObjects (roKey, roOwnerRestricting, pos, roType) VALUES ('00000000000000000000000000000004', '00000000000000000000000000000001', 1, 10);\n" //$NON-NLS-1$
        + "INSERT INTO Concepts (roKey, value) VALUES ('00000000000000000000000000000004', 'AuditableEvent');\n" //$NON-NLS-1$
        + "INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES ('00000000000000000000000000000004', 0, 'en', 'UTF-8', 'AuditableEvent');\n" //$NON-NLS-1$
        + "\n" //$NON-NLS-1$
        + "INSERT INTO RegistryObjects (roKey, roOwnerRestricting, pos, roType) VALUES ('00000000000000000000000000000005', '00000000000000000000000000000001', 2, 10);\n" //$NON-NLS-1$
        + "INSERT INTO Concepts (roKey, value) VALUES ('00000000000000000000000000000005', 'Classification');\n" //$NON-NLS-1$
        + "INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES ('00000000000000000000000000000005', 0, 'en', 'UTF-8', 'Classification');\n" //$NON-NLS-1$
        + "\n"; //$NON-NLS-1$

    /**
     * Test for the &{macro, ...} definition.
     * @throws IOException 
     */
    @Test
    public void testMacroDefinition() throws IOException {
        final StringReader sr = new StringReader(document);
        final MacroProcessor mp = MacroProcessor.newInstance(sr);
        final StringWriter sw = new StringWriter();
        final char[] buffer = new char[1024];
        for (;;) {
            int res = mp.read(buffer);
            if (res == -1) {
                break;
            }
            if (res > 0) {
                sw.write(buffer, 0, res);
            }
        }
        assertEquals(processedDocument, sw.toString());
    }
}
