/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.JAXRException;
import org.apache.labs.jaxmas.registry.infomodel.ConnectionImpl;
import org.apache.labs.jaxmas.registry.infomodel.NLSStrings;
import org.apache.labs.jaxmas.registry.util.Locales;
import org.apache.labs.jaxmas.registry.util.Strings;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    public static final String PROPERTY_LOCALE = ConnectionFactoryImpl.class.getName() + ".LOCALE";
    public static final String PROPERTY_DRIVER = ConnectionFactoryImpl.class.getName() + ".DRIVER";
    public static final String PROPERTY_URL = ConnectionFactoryImpl.class.getName() + ".URL";
    public static final String PROPERTY_USER = ConnectionFactoryImpl.class.getName() + ".USER";
    public static final String PROPERTY_PASSWORD = ConnectionFactoryImpl.class.getName() + ".PASSWORD";
    private Properties properties;

    private Locale getLocale() {
        String localeProperty = this.getProperty(PROPERTY_LOCALE);
        if (localeProperty != null) {
            return Locales.getLocale(localeProperty);
        }
        return Locale.getDefault();
    }

    private String getProperty(String pProperty) {
        return this.properties == null ? null : (String)this.properties.get(pProperty);
    }

    private String requireProperty(String pProperty, NLSStrings pBundle) throws JAXRException {
        String s = this.getProperty(pProperty);
        if (s == null) {
            throw new JAXRException(pBundle.format("PROPERTY_NOT_SET", pProperty));
        }
        return s;
    }

    public Connection createConnection() throws JAXRException {
        NLSStrings bundle = this.getBundle();
        String driver = this.getProperty(PROPERTY_DRIVER);
        if (!Strings.isEmpty(driver)) {
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                throw new JAXRException((Throwable)e);
            }
        }
        String url = this.requireProperty(PROPERTY_URL, bundle);
        String user = this.getProperty(PROPERTY_USER);
        try {
            java.sql.Connection conn;
            if (user == null) {
                conn = DriverManager.getConnection(url);
            } else {
                String password = this.requireProperty(PROPERTY_PASSWORD, bundle);
                conn = DriverManager.getConnection(url, user, password);
            }
            return new ConnectionImpl(conn, bundle);
        }
        catch (SQLException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    private NLSStrings getBundle() {
        Locale locale = this.getLocale();
        NLSStrings bundle = new NLSStrings(locale);
        return bundle;
    }

    public FederatedConnection createFederatedConnection(Collection pConnections) throws JAXRException {
        NLSStrings bundle = this.getBundle();
        throw new JAXRException(bundle.get("OPERATION_NOT_IMPLEMENTED"));
    }

    public Properties getProperties() throws JAXRException {
        return this.properties;
    }

    public void setProperties(Properties pProperties) throws JAXRException {
        this.properties = pProperties;
    }
}

