/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.accessor;

import java.util.Map;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Slot;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;
import org.apache.labs.jaxmas.registry.infomodel.ROState;
import org.apache.labs.jaxmas.registry.infomodel.RegistryObjectImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.DbDriver;

public abstract class AbstractROAccessor<RO extends RegistryObject>
implements ROAccessor<RO> {
    protected abstract RO newInstance(RegistryServiceImpl var1, Key var2) throws JAXRException;

    protected DbDriver getDbDriver(RegistryService pRegistryService) {
        return ((RegistryServiceImpl)pRegistryService).getDbDriver();
    }

    @Override
    public Key newKey(RegistryService pRegistryService) throws JAXRException {
        long id = this.getDbDriver(pRegistryService).newId("keys");
        String s = String.valueOf(id);
        String key = "00000000000000000000000000000000".substring(s.length()) + s;
        return pRegistryService.getBusinessLifeCycleManager().createKey(key);
    }

    @Override
    public RO create(RegistryService pRegistryService) throws JAXRException {
        RO ro = this.newInstance((RegistryServiceImpl)pRegistryService, null);
        ro.setKey(this.newKey(pRegistryService));
        return ro;
    }

    @Override
    public RO create(RegistryService pRegistryService, Key pKey) throws JAXRException {
        return this.newInstance((RegistryServiceImpl)pRegistryService, pKey);
    }

    @Override
    public Map<String, Slot> getSlots(RegistryService pRegistryService, RO pRegistryObject) throws JAXRException {
        return this.getDbDriver(pRegistryService).getSlots((RegistryObject)pRegistryObject);
    }

    @Override
    public void save(RegistryService pRegistryService, RegistryObject pObject) throws JAXRException {
        RegistryObjectImpl ro = (RegistryObjectImpl)pObject;
        switch (ro.getState()) {
            case created: {
                this.getDbDriver(pRegistryService).insert(pObject, this.getRegistryObjectType());
                break;
            }
            case loaded: 
            case referenced: {
                this.getDbDriver(pRegistryService).update(pObject);
                break;
            }
            case deleted: {
                throw new IllegalStateException("Unable to save a deleted object.");
            }
        }
        ro.setState(ROState.loaded);
    }

    @Override
    public void remove(RegistryService pRegistryService, RO pRegistryObject) throws JAXRException {
        DbDriver dbDriver = this.getDbDriver(pRegistryService);
        dbDriver.deleteRegistryObject(pRegistryObject.getKey());
        dbDriver.deleteSlots((RegistryObject)pRegistryObject);
    }

    @Override
    public void load(RegistryServiceImpl pRegistryService, RegistryObject pRegistryObject) throws JAXRException {
        this.getRegistryObjectLoader().load(pRegistryService, pRegistryObject);
    }
}

