/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.accessor;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Key;
import org.apache.labs.jaxmas.registry.accessor.AbstractROAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessors;
import org.apache.labs.jaxmas.registry.infomodel.ClassificationSchemeImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.FilterPredicate;
import org.apache.labs.jaxmas.registry.sql.NamePredicate;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectLoader;

public class ClassificationSchemeAccessor
extends AbstractROAccessor<ClassificationScheme> {
    private static final ClassificationSchemeAccessor theInstance = new ClassificationSchemeAccessor();
    private static final RegistryObjectLoader rol;

    private ClassificationSchemeAccessor() {
    }

    public static ClassificationSchemeAccessor getInstance() {
        return theInstance;
    }

    @Override
    public int getRegistryObjectType() {
        return ROAccessors.ObjectTypes.CLASSIFICATION_SCHEME.ordinal();
    }

    private static Collection<String> asStringCollection(Collection<?> pCollection) {
        return pCollection;
    }

    private static List<ClassificationScheme> asClassificationSchemeList(List<?> pList) {
        return pList;
    }

    public List<ClassificationScheme> findClassificationSchemes(RegistryService pRegistryService, Collection<?> pFindQualifiers, Collection<?> pNamePatterns, Collection<?> pClassifications, Collection<?> pExternalLinks) throws JAXRException {
        ArrayList<FilterPredicate> predicates = new ArrayList<FilterPredicate>();
        if (pFindQualifiers != null && !pFindQualifiers.isEmpty()) {
            for (Object o : pFindQualifiers) {
                if ("exactNameMatch".equals(o)) continue;
                throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pFindQualifiers"));
            }
        }
        if (pNamePatterns != null && !pNamePatterns.isEmpty()) {
            predicates.add(new NamePredicate(ClassificationSchemeAccessor.asStringCollection(pNamePatterns)));
        }
        if (pClassifications != null && !pClassifications.isEmpty()) {
            throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pClassifications"));
        }
        if (pExternalLinks != null && !pExternalLinks.isEmpty()) {
            throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pExternalLinks"));
        }
        return ClassificationSchemeAccessor.asClassificationSchemeList(rol.getResultList(pRegistryService, predicates, null));
    }

    @Override
    public void remove(RegistryService pRegistryService, ClassificationScheme pRegistryObject) throws JAXRException {
        super.remove(pRegistryService, pRegistryObject);
    }

    @Override
    protected ClassificationScheme newInstance(RegistryServiceImpl pRegistryService, Key pKey) throws JAXRException {
        return new ClassificationSchemeImpl(pRegistryService, pKey);
    }

    @Override
    public RegistryObjectLoader getRegistryObjectLoader() {
        return rol;
    }

    static {
        try {
            rol = new RegistryObjectLoader(ROAccessors.ObjectTypes.CLASSIFICATION_SCHEME, null, null);
        }
        catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

