/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.accessor;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import org.apache.labs.jaxmas.registry.accessor.AbstractROAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessors;
import org.apache.labs.jaxmas.registry.infomodel.OrganizationImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.FilterPredicate;
import org.apache.labs.jaxmas.registry.sql.NamePredicate;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectLoader;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectTypePredicate;

public class OrganizationAccessor
extends AbstractROAccessor<Organization> {
    private static final RegistryObjectLoader rol;
    private static final OrganizationAccessor theInstance;

    private OrganizationAccessor() {
    }

    public static OrganizationAccessor getInstance() {
        return theInstance;
    }

    @Override
    protected Organization newInstance(RegistryServiceImpl pRegistryService, Key pKey) throws JAXRException {
        return new OrganizationImpl(pRegistryService, pKey);
    }

    @Override
    public RegistryObjectLoader getRegistryObjectLoader() {
        return rol;
    }

    @Override
    public int getRegistryObjectType() {
        return ROAccessors.ObjectTypes.ORGANIZATION.ordinal();
    }

    private static Collection<String> asStringCollection(Collection<?> pCollection) {
        return pCollection;
    }

    private static List<Organization> asOrganizationList(List<?> pList) {
        return pList;
    }

    public List<Organization> findOrganizations(RegistryService pRegistryService, Collection<?> pFindQualifiers, Collection<?> pNamePatterns, Collection<?> pClassifications, Collection<?> pSpecifications, Collection<?> pExternalIdentifiers, Collection<?> pExternalLinks) throws JAXRException {
        ArrayList<FilterPredicate> predicates = new ArrayList<FilterPredicate>();
        predicates.add(new RegistryObjectTypePredicate(ROAccessors.ObjectTypes.ORGANIZATION));
        if (pFindQualifiers != null && !pFindQualifiers.isEmpty()) {
            for (Object o : pFindQualifiers) {
                if ("exactNameMatch".equals(o)) continue;
                throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pFindQualifiers"));
            }
        }
        if (pNamePatterns != null && !pNamePatterns.isEmpty()) {
            predicates.add(new NamePredicate(OrganizationAccessor.asStringCollection(pNamePatterns)));
        }
        if (pClassifications != null && !pClassifications.isEmpty()) {
            throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pClassifications"));
        }
        if (pSpecifications != null && !pSpecifications.isEmpty()) {
            throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pSpecifications"));
        }
        if (pExternalIdentifiers != null && !pExternalIdentifiers.isEmpty()) {
            throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pExternalIdentifiers"));
        }
        if (pExternalLinks != null && !pExternalLinks.isEmpty()) {
            throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pExternalLinks"));
        }
        return OrganizationAccessor.asOrganizationList(rol.getResultList(pRegistryService, predicates, null));
    }

    static {
        try {
            rol = new RegistryObjectLoader(ROAccessors.ObjectTypes.ORGANIZATION, null, null);
        }
        catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            throw new UndeclaredThrowableException(e);
        }
        theInstance = new OrganizationAccessor();
    }
}

