/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.accessor;

import java.util.HashMap;
import java.util.Map;
import org.apache.labs.jaxmas.registry.accessor.AssociationAccessor;
import org.apache.labs.jaxmas.registry.accessor.AuditableEventAccessor;
import org.apache.labs.jaxmas.registry.accessor.ClassificationAccessor;
import org.apache.labs.jaxmas.registry.accessor.ClassificationSchemeAccessor;
import org.apache.labs.jaxmas.registry.accessor.ConceptAccessor;
import org.apache.labs.jaxmas.registry.accessor.ExternalIdentifierAccessor;
import org.apache.labs.jaxmas.registry.accessor.ExternalLinkAccessor;
import org.apache.labs.jaxmas.registry.accessor.ExtrinsicObjectAccessor;
import org.apache.labs.jaxmas.registry.accessor.OrganizationAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;
import org.apache.labs.jaxmas.registry.accessor.RegistryEntryAccessor;
import org.apache.labs.jaxmas.registry.accessor.RegistryPackageAccessor;
import org.apache.labs.jaxmas.registry.accessor.ServiceAccessor;
import org.apache.labs.jaxmas.registry.accessor.ServiceBindingAccessor;
import org.apache.labs.jaxmas.registry.accessor.SpecificationLinkAccessor;
import org.apache.labs.jaxmas.registry.accessor.UserAccessor;

public class ROAccessors {
    private static final ROAccessor<?>[] roAccessors = new ROAccessor[]{AssociationAccessor.getInstance(), AuditableEventAccessor.getInstance(), ClassificationAccessor.getInstance(), ExternalIdentifierAccessor.getInstance(), ExternalLinkAccessor.getInstance(), RegistryEntryAccessor.getInstance(), ServiceAccessor.getInstance(), ClassificationSchemeAccessor.getInstance(), UserAccessor.getInstance(), OrganizationAccessor.getInstance(), ConceptAccessor.getInstance(), ServiceBindingAccessor.getInstance(), SpecificationLinkAccessor.getInstance(), ExtrinsicObjectAccessor.getInstance(), RegistryPackageAccessor.getInstance()};
    private static final Map<String, ROAccessor<?>> roAccessorsByInterfaceName = new HashMap();

    public static ROAccessor<?> getROAccessor(ObjectTypes pRoType) {
        return roAccessors[pRoType.ordinal()];
    }

    public static ROAccessor<?> getROAccessor(String pInterfaceName) {
        return roAccessorsByInterfaceName.get(pInterfaceName);
    }

    public static ROAccessor<?> getROAccessor(int pRoType) {
        return roAccessors[pRoType];
    }

    public static ConceptAccessor getConceptAccessor() {
        return (ConceptAccessor)ROAccessors.getROAccessor(ObjectTypes.CONCEPT);
    }

    public static ClassificationSchemeAccessor getClassificationSchemeAccessor() {
        return (ClassificationSchemeAccessor)ROAccessors.getROAccessor(ObjectTypes.CLASSIFICATION_SCHEME);
    }

    static {
        for (ObjectTypes type : ObjectTypes.values()) {
            ROAccessor<?> roAcc = roAccessors[type.ordinal()];
            roAccessorsByInterfaceName.put(type.getInterfaceName(), roAcc);
        }
    }

    public static enum ObjectTypes {
        ASSOCIATION("00000000000000000000000000000003", "Association"),
        AUDITABLE_EVENT("00000000000000000000000000000004", "AuditableEvent"),
        CLASSIFICATION("00000000000000000000000000000005", "Classification"),
        EXTERNAL_IDENTIFIER("00000000000000000000000000000006", "ExternalIdentifier"),
        EXTERNAL_LINK("00000000000000000000000000000007", "ExternalLink"),
        REGISTRY_ENTRY("00000000000000000000000000000009", "RegistryEntry"),
        SERVICE("000000000000000000000000000000010", "Service"),
        CLASSIFICATION_SCHEME("00000000000000000000000000000011", "ClassificationScheme"),
        USER("00000000000000000000000000000012", "User"),
        ORGANIZATION("00000000000000000000000000000015", "Organization"),
        CONCEPT("00000000000000000000000000000016", "Concept"),
        SERVICE_BINDING("00000000000000000000000000000017", "ServiceBinding"),
        SPECIFICATION_LINK("00000000000000000000000000000018", "SpecificationLink"),
        REGISTRY_PACKAGE("00000000000000000000000000000019", "RegistryPackage"),
        EXTRINSIC_OBJECT("000000000000000000000000000000020", "ExtrinsicObject");

        private final String id;
        private final String ifaceName;

        private ObjectTypes(String pId, String pInterfaceName) {
            this.id = pId;
            this.ifaceName = pInterfaceName;
        }

        public String getId() {
            return this.id;
        }

        public String getInterfaceName() {
            return this.ifaceName;
        }
    }

    public static enum ClassificationSchemes {
        OBJECT_TYPE("00000000000000000000000000000001", "ObjectType"),
        ASSOCIATION_TYPE("00000000000000000000000000000002", "AssociationType");

        private final String id;
        private final String name;

        private ClassificationSchemes(String pId, String pName) {
            this.id = pId;
            this.name = pName;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

