/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.accessor;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryEntry;
import org.apache.labs.jaxmas.registry.accessor.AbstractROAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessors;
import org.apache.labs.jaxmas.registry.infomodel.RegistryEntryImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.CustomObjectTypePredicate;
import org.apache.labs.jaxmas.registry.sql.FilterPredicate;
import org.apache.labs.jaxmas.registry.sql.NamePredicate;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectLoader;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectTypePredicate;

public class RegistryEntryAccessor
extends AbstractROAccessor<RegistryEntry> {
    private static final RegistryObjectLoader rol;
    private static final RegistryEntryAccessor theInstance;

    private RegistryEntryAccessor() {
    }

    public static RegistryEntryAccessor getInstance() {
        return theInstance;
    }

    @Override
    public int getRegistryObjectType() {
        return ROAccessors.ObjectTypes.REGISTRY_ENTRY.ordinal();
    }

    @Override
    protected RegistryEntry newInstance(RegistryServiceImpl pRegistryService, Key pKey) throws JAXRException {
        return new RegistryEntryImpl(pRegistryService, pKey);
    }

    @Override
    public RegistryObjectLoader getRegistryObjectLoader() {
        return rol;
    }

    private static List<RegistryEntry> asRegistryEntryList(List<?> pList) {
        return pList;
    }

    public List<RegistryEntry> findRegistryEntries(RegistryService pRegistryService, Collection<String> pFindQualifiers, Collection<String> pObjectTypes, Collection<String> pNamePatterns, Collection<String> pDescriptionPatterns, Collection<?> pClassifications, Collection<?> pExternalIdentifiers, Collection<?> pExternalLinks) throws JAXRException {
        ArrayList<FilterPredicate> predicates = new ArrayList<FilterPredicate>();
        if (pObjectTypes == null || pObjectTypes.isEmpty()) {
            predicates.add(new RegistryObjectTypePredicate(ROAccessors.ObjectTypes.REGISTRY_ENTRY));
        } else {
            predicates.add(new CustomObjectTypePredicate(pObjectTypes));
        }
        if (pFindQualifiers != null && !pFindQualifiers.isEmpty()) {
            for (String o : pFindQualifiers) {
                if ("exactNameMatch".equals(o)) continue;
                throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pFindQualifiers"));
            }
        }
        if (pNamePatterns != null && !pNamePatterns.isEmpty()) {
            predicates.add(new NamePredicate(pNamePatterns));
        }
        if (pDescriptionPatterns != null && !pDescriptionPatterns.isEmpty()) {
            throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pDescriptionPatterns"));
        }
        if (pClassifications != null && !pClassifications.isEmpty()) {
            throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pClassifications"));
        }
        if (pExternalIdentifiers != null && !pExternalIdentifiers.isEmpty()) {
            throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pExternalIdentifiers"));
        }
        if (pExternalLinks != null && !pExternalLinks.isEmpty()) {
            throw new JAXRException(RegistryServiceImpl.getNLSStrings(pRegistryService).format("UNSUPPORTED_PARAMETER", "pExternalLinks"));
        }
        return RegistryEntryAccessor.asRegistryEntryList(rol.getResultList(pRegistryService, predicates, null));
    }

    static {
        try {
            rol = new RegistryObjectLoader(ROAccessors.ObjectTypes.REGISTRY_ENTRY, null, null);
        }
        catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            throw new UndeclaredThrowableException(e);
        }
        theInstance = new RegistryEntryAccessor();
    }
}

