/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.labs.jaxmas.registry.accessor.AssociationAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;
import org.apache.labs.jaxmas.registry.infomodel.OwnedRegistryObject;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;

public class AssociationImpl
extends OwnedRegistryObject<Association>
implements Association {
    private Key associationTypeKey;
    private Concept associationType;
    private Key targetObjectKey;
    private RegistryObject targetObject;
    private boolean confirmed;
    private boolean confirmedBySourceOwner;
    private boolean confirmedByTargetOwner;
    private boolean extramural;
    private int num;

    public AssociationImpl(RegistryServiceImpl pRegistryService, Key pKey) {
        super(pRegistryService, pKey);
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int pNum) {
        this.num = pNum;
    }

    public Concept getAssociationType() throws JAXRException {
        this.ensureLoaded();
        if (this.associationType == null && this.associationTypeKey != null) {
            this.associationType = (Concept)this.getRegistryService().getBusinessQueryManager().getRegistryObject(this.associationTypeKey.getId());
        }
        return this.associationType;
    }

    public RegistryObject getSourceObject() throws JAXRException {
        return this.getOwner();
    }

    public RegistryObject getTargetObject() throws JAXRException {
        this.ensureLoaded();
        if (this.targetObject == null && this.targetObjectKey != null) {
            this.targetObject = this.getRegistryService().getBusinessQueryManager().getRegistryObject(this.targetObjectKey.getId());
        }
        return this.targetObject;
    }

    public boolean isConfirmed() throws JAXRException {
        return this.confirmed;
    }

    public boolean isConfirmedBySourceOwner() throws JAXRException {
        return this.confirmedBySourceOwner;
    }

    public boolean isConfirmedByTargetOwner() throws JAXRException {
        return this.confirmedByTargetOwner;
    }

    public boolean isExtramural() throws JAXRException {
        return this.extramural;
    }

    public void setAssociationTypeKey(Key pKey) throws JAXRException {
        this.ensureLoaded();
        if (pKey == null) {
            this.associationType = null;
        } else if (this.associationType != null && !this.associationType.getKey().equals(pKey)) {
            this.associationType = null;
        }
        this.associationTypeKey = pKey;
    }

    public void setAssociationType(Concept pAssociationType) throws JAXRException {
        this.ensureLoaded();
        this.associationType = pAssociationType;
        this.associationTypeKey = pAssociationType == null ? null : pAssociationType.getKey();
    }

    public void setSourceObject(RegistryObject pSource) throws JAXRException {
        this.setOwner(pSource);
    }

    public void setTargetObject(RegistryObject pTarget) throws JAXRException {
        this.ensureLoaded();
        this.targetObject = pTarget;
        this.targetObjectKey = pTarget == null ? null : pTarget.getKey();
    }

    public void setTargetObjectKey(Key pTargetKey) throws JAXRException {
        this.ensureLoaded();
        if (pTargetKey == null) {
            this.targetObject = null;
        } else if (this.targetObject != null && !this.targetObject.getKey().equals(pTargetKey)) {
            this.targetObject = null;
        }
        this.targetObjectKey = pTargetKey;
    }

    @Override
    public ROAccessor<Association> getROLoader() {
        return AssociationAccessor.getInstance();
    }

    @Override
    public boolean isRestricting() {
        return false;
    }
}

