/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryEntry;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.labs.jaxmas.registry.accessor.AssociationAccessor;
import org.apache.labs.jaxmas.registry.accessor.ClassificationSchemeAccessor;
import org.apache.labs.jaxmas.registry.accessor.OrganizationAccessor;
import org.apache.labs.jaxmas.registry.accessor.RegistryEntryAccessor;
import org.apache.labs.jaxmas.registry.infomodel.BulkResponseImpl;
import org.apache.labs.jaxmas.registry.infomodel.JaxMasQueryManager;
import org.apache.labs.jaxmas.registry.infomodel.QueryManagerImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.AssociationSourcePredicate;
import org.apache.labs.jaxmas.registry.sql.AssociationTargetPredicate;
import org.apache.labs.jaxmas.registry.sql.AssociationTypePredicate;
import org.apache.labs.jaxmas.registry.sql.FilterPredicate;

public class BusinessQueryManagerImpl
extends QueryManagerImpl
implements BusinessQueryManager,
JaxMasQueryManager {
    public BusinessQueryManagerImpl(RegistryServiceImpl pRegistryService) {
        super(pRegistryService);
    }

    public BulkResponse findAssociations(Collection pFindQualifiers, String pSourceObjectId, String pTargetObjectId, Collection pAssociationTypes) throws JAXRException {
        ArrayList<FilterPredicate> predicates = new ArrayList<FilterPredicate>();
        if (pFindQualifiers != null && pFindQualifiers.size() > 0) {
            throw new JAXRException("UNSUPPORTED_PARAMETER");
        }
        if (pSourceObjectId != null) {
            predicates.add(new AssociationSourcePredicate(pSourceObjectId));
        }
        if (pTargetObjectId != null) {
            predicates.add(new AssociationTargetPredicate(pTargetObjectId));
        }
        if (pAssociationTypes != null && pAssociationTypes.size() > 0) {
            predicates.add(new AssociationTypePredicate(pAssociationTypes));
        }
        List<RegistryObject> assocs = AssociationAccessor.getInstance().getRegistryObjectLoader().getResultList(this.getRegistryService(), predicates, null);
        return new BulkResponseImpl(assocs);
    }

    public BulkResponse findCallerAssociations(Collection pFindQualifiers, Boolean pConfirmedByCaller, Boolean pConfirmedByOtherParty, Collection pAssociationTypes) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public ClassificationScheme findClassificationSchemeByName(Collection pFindQualifiers, String pNamePatterns) throws JAXRException {
        List<ClassificationScheme> result = ClassificationSchemeAccessor.getInstance().findClassificationSchemes(this.getRegistryService(), pFindQualifiers, Collections.singleton(pNamePatterns), null, null);
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new JAXRException("MULTIPLE_INSTANCES_FOUND");
        }
        return result.get(0);
    }

    public BulkResponse findClassificationSchemes(Collection pFindQualifiers, Collection pNamePatterns, Collection pClassifications, Collection pExternalLinks) throws JAXRException {
        List<ClassificationScheme> list = ClassificationSchemeAccessor.getInstance().findClassificationSchemes(this.getRegistryService(), pFindQualifiers, pNamePatterns, pClassifications, pExternalLinks);
        return new BulkResponseImpl(list);
    }

    private Concept findConcept(Collection<?> pConcepts, String pValue) throws JAXRException {
        if (pConcepts != null) {
            for (Object o : pConcepts) {
                Concept concept = (Concept)o;
                if (!pValue.equals(concept.getValue())) continue;
                return concept;
            }
        }
        return null;
    }

    public Concept findConceptByPath(String pPath) throws JAXRException {
        StringTokenizer st = new StringTokenizer(pPath, "/");
        if (!st.hasMoreTokens()) {
            throw new JAXRException("Invalid concept path: " + pPath);
        }
        String classificationSchemeName = st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new JAXRException("Invalid classification scheme " + classificationSchemeName + " in path " + pPath);
        }
        ClassificationScheme cs = this.findClassificationSchemeByName(null, classificationSchemeName);
        if (cs == null) {
            return null;
        }
        Concept concept = this.findConcept(cs.getChildrenConcepts(), st.nextToken());
        if (concept == null) {
            return null;
        }
        while (st.hasMoreTokens()) {
            if ((concept = this.findConcept(concept.getChildrenConcepts(), st.nextToken())) != null) continue;
            return null;
        }
        return concept;
    }

    public BulkResponse findConcepts(Collection pFindQualifiers, Collection pNamePatterns, Collection pClassifications, Collection pExternalIdentifiers, Collection pExternalLinks) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public BulkResponse findOrganizations(Collection pFindQualifiers, Collection pNamePatterns, Collection pClassifications, Collection pSpecifications, Collection pExternalIdentifiers, Collection pExternalLinks) throws JAXRException {
        List<Organization> list = OrganizationAccessor.getInstance().findOrganizations(this.getRegistryService(), pFindQualifiers, pNamePatterns, pClassifications, pSpecifications, pExternalIdentifiers, pExternalLinks);
        return new BulkResponseImpl(list);
    }

    public BulkResponse findRegistryPackages(Collection pFindQualifiers, Collection pNamePatterns, Collection pClassifications, Collection pExternalLinks) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public BulkResponse findServiceBindings(Key pServiceKey, Collection pFindQualifiers, Collection pClassifications, Collection pSpecificationa) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public BulkResponse findServices(Key pOrgKey, Collection pFindQualifiers, Collection pNamePattersn, Collection pClassifications, Collection pSpecificationa) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    @Override
    public BulkResponse findObjects(Collection<String> pFindQualifiers, Collection<String> pObjectTypes, Collection<String> pNamePatterns, Collection<String> pDescriptionPatterns, Collection<?> pClassifications, Collection<?> pExternalIdentifiers, Collection<?> pExternalLinks) throws JAXRException {
        List<RegistryEntry> list = RegistryEntryAccessor.getInstance().findRegistryEntries(this.getRegistryService(), pFindQualifiers, pObjectTypes, pNamePatterns, pDescriptionPatterns, pClassifications, pExternalIdentifiers, pExternalLinks);
        return new BulkResponseImpl(list);
    }
}

