/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.labs.jaxmas.registry.accessor.ConceptAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessors;
import org.apache.labs.jaxmas.registry.infomodel.ConceptImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryObjectImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.OwnerPredicate;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectLoader;

class ConceptChildrenController {
    private static final RegistryObjectLoader rol;
    private final RegistryObjectImpl<?> registryObject;
    private List<Concept> storedChildren = new ArrayList<Concept>();
    private Collection<Concept> children;

    ConceptChildrenController(RegistryObjectImpl<?> pRegistryObject) {
        this.registryObject = pRegistryObject;
    }

    private void initStoredChildren() {
        this.storedChildren.clear();
        if (this.children != null) {
            this.storedChildren.addAll(this.children);
        }
    }

    private Collection<Concept> getChildren() throws JAXRException {
        if (this.children == null) {
            OwnerPredicate predicate = new OwnerPredicate(this.registryObject.getKey(), true);
            this.children = ConceptChildrenController.asConceptCollection(rol.getResultList((RegistryService)this.registryObject.getRegistryService(), Collections.singleton(predicate), null));
            this.initStoredChildren();
        }
        return this.children;
    }

    void addChildConcept(Concept pConcept) throws JAXRException {
        if (pConcept == null) {
            throw new IllegalArgumentException(this.registryObject.getNLSStrings().format("NULL_PARAMETER", "pConcept"));
        }
        ((ConceptImpl)pConcept).setOwner(this.registryObject);
        this.getChildren().add(pConcept);
    }

    void addChildConcepts(Collection<Concept> pConcepts) throws JAXRException {
        if (pConcepts == null) {
            throw new IllegalArgumentException(this.registryObject.getNLSStrings().format("NULL_PARAMETER", "pConcepts"));
        }
        for (Concept c : pConcepts) {
            this.addChildConcept(c);
        }
    }

    int getChildConceptCount() throws JAXRException {
        return this.getChildren().size();
    }

    Collection<Concept> getChildrenConcepts() throws JAXRException {
        return Collections.unmodifiableCollection(this.getChildren());
    }

    void removeChildConcept(Concept pConcept) throws JAXRException {
        if (pConcept == null) {
            throw new IllegalArgumentException(this.registryObject.getNLSStrings().format("NULL_PARAMETER", "pConcept"));
        }
        this.getChildren().remove(pConcept);
    }

    void removeChildConcepts(Collection<Concept> pConcepts) throws JAXRException {
        if (pConcepts == null) {
            throw new IllegalArgumentException(this.registryObject.getNLSStrings().format("NULL_PARAMETER", "pConcepts"));
        }
        for (Concept o : pConcepts) {
            this.removeChildConcept(o);
        }
    }

    private static final Collection<Concept> asConceptCollection(Collection<?> pConcepts) {
        return pConcepts;
    }

    private void addDescendantConcepts(Collection<Concept> pTargetCollection, Collection<Concept> pChildrenCollection) throws JAXRException {
        if (pChildrenCollection != null) {
            for (Concept concept : pChildrenCollection) {
                pTargetCollection.add(concept);
                this.addDescendantConcepts(pTargetCollection, ConceptChildrenController.asConceptCollection(concept.getChildrenConcepts()));
            }
        }
    }

    Collection<Concept> getDescendantConcepts() throws JAXRException {
        ArrayList<Concept> descendants = new ArrayList<Concept>();
        this.addDescendantConcepts(descendants, this.getChildrenConcepts());
        return Collections.unmodifiableCollection(descendants);
    }

    public void save() throws JAXRException {
        if (this.children == null) {
            return;
        }
        ConceptAccessor conceptAccessor = ROAccessors.getConceptAccessor();
        RegistryServiceImpl registryService = this.registryObject.getRegistryService();
        int i = 0;
        for (Concept concept : this.children) {
            Iterator<Concept> iter = this.storedChildren.iterator();
            while (iter.hasNext()) {
                Concept child = iter.next();
                if (!child.getKey().equals(concept.getKey())) continue;
                iter.remove();
                break;
            }
            conceptAccessor.save(registryService, (RegistryObject)concept);
            ++i;
        }
        for (Concept concept : this.storedChildren) {
            conceptAccessor.remove(registryService, concept);
        }
        this.initStoredChildren();
    }

    static {
        try {
            rol = new RegistryObjectLoader(ROAccessors.ObjectTypes.CONCEPT, null, null);
        }
        catch (SQLException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

