/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.labs.jaxmas.registry.accessor.ConceptAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;
import org.apache.labs.jaxmas.registry.infomodel.ConceptChildrenController;
import org.apache.labs.jaxmas.registry.infomodel.OwnedRegistryObject;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;

public class ConceptImpl
extends OwnedRegistryObject<Concept>
implements Concept {
    private String value;
    private final ConceptChildrenController childrenConceptList = new ConceptChildrenController(this);

    public ConceptImpl(RegistryServiceImpl pRegistryService, Key pKey) {
        super(pRegistryService, pKey);
    }

    public Concept getParentConcept() throws JAXRException {
        Concept p = this.getParentConcept();
        if (p instanceof Concept) {
            return p;
        }
        return null;
    }

    public String getPath() throws JAXRException {
        Concept parentConcept = this.getParentConcept();
        if (parentConcept == null) {
            return "/" + this.getValue();
        }
        return parentConcept.getPath() + "/" + this.getValue();
    }

    public String getValue() throws JAXRException {
        this.ensureLoaded();
        return this.value;
    }

    public void setValue(String pValue) throws JAXRException {
        this.ensureLoaded();
        this.value = pValue;
    }

    public ClassificationScheme getClassificationScheme() throws JAXRException {
        RegistryObject owner = this.getOwner();
        return owner instanceof ClassificationScheme ? (ClassificationScheme)owner : ((Concept)owner).getClassificationScheme();
    }

    public RegistryObject getParent() throws JAXRException {
        return this.getOwner();
    }

    public void addChildConcept(Concept pConcept) throws JAXRException {
        this.childrenConceptList.addChildConcept(pConcept);
    }

    private static final Collection<Concept> asConceptCollection(Collection<?> pConcepts) {
        return pConcepts;
    }

    public void addChildConcepts(Collection pConcepts) throws JAXRException {
        this.childrenConceptList.addChildConcepts(ConceptImpl.asConceptCollection(pConcepts));
    }

    public int getChildConceptCount() throws JAXRException {
        return this.childrenConceptList.getChildConceptCount();
    }

    public Collection getChildrenConcepts() throws JAXRException {
        return this.childrenConceptList.getChildrenConcepts();
    }

    public Collection getDescendantConcepts() throws JAXRException {
        return this.childrenConceptList.getDescendantConcepts();
    }

    public void removeChildConcept(Concept pConcept) throws JAXRException {
        this.childrenConceptList.removeChildConcept(pConcept);
    }

    public void removeChildConcepts(Collection pConcepts) throws JAXRException {
        this.childrenConceptList.removeChildConcepts(ConceptImpl.asConceptCollection(pConcepts));
    }

    @Override
    public ROAccessor<Concept> getROLoader() {
        return ConceptAccessor.getInstance();
    }

    @Override
    public boolean isRestricting() {
        return true;
    }
}

