/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import org.apache.labs.jaxmas.registry.infomodel.NLSStrings;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;

public class ConnectionImpl
implements Connection {
    private final NLSStrings nlsStrings;
    private final RegistryService registryService;
    private java.sql.Connection connection;
    private Set<?> credentials;
    private boolean synchronous;

    public ConnectionImpl(java.sql.Connection pConnection, NLSStrings pNLSStrings) throws SQLException {
        this.connection = pConnection;
        this.nlsStrings = pNLSStrings;
        this.registryService = new RegistryServiceImpl(this);
    }

    public void close() throws JAXRException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new JAXRException((Throwable)e);
            }
            this.connection = null;
        }
    }

    public Set getCredentials() throws JAXRException {
        return this.credentials;
    }

    public RegistryService getRegistryService() throws JAXRException {
        return this.registryService;
    }

    public boolean isClosed() throws JAXRException {
        return this.connection == null;
    }

    public boolean isSynchronous() throws JAXRException {
        return this.synchronous;
    }

    public void setCredentials(Set pCredentials) throws JAXRException {
        this.credentials = pCredentials;
    }

    public void setSynchronous(boolean pSync) throws JAXRException {
        this.synchronous = pSync;
    }

    public java.sql.Connection getConnection() {
        return this.connection;
    }

    public NLSStrings getNLSStrings() {
        return this.nlsStrings;
    }

    public Locale getLocale() {
        return this.nlsStrings.getLocale();
    }

    public static Locale getLocale(Connection pConnection) {
        return ((ConnectionImpl)pConnection).getLocale();
    }

    public static NLSStrings getNLSStrings(Connection pConnection) {
        return ((ConnectionImpl)pConnection).getNLSStrings();
    }
}

