/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Collection;
import java.util.Map;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ExtensibleObject;
import javax.xml.registry.infomodel.Slot;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;

public abstract class ExtensibleObjectImpl
implements ExtensibleObject {
    private final RegistryServiceImpl registryService;
    private Map<String, Slot> slts;

    protected abstract Map<String, Slot> loadSlots() throws JAXRException;

    public boolean hasSlotsLoaded() {
        return this.slts != null;
    }

    private Map<String, Slot> slots() throws JAXRException {
        if (this.slts == null) {
            this.slts = this.loadSlots();
        }
        return this.slts;
    }

    public ExtensibleObjectImpl(RegistryServiceImpl pRegistryService) {
        this.registryService = pRegistryService;
    }

    public RegistryServiceImpl getRegistryService() {
        return this.registryService;
    }

    public void addSlot(Slot pSlot) throws JAXRException {
        this.slots().put(pSlot.getName(), pSlot);
    }

    public void addSlots(Collection pSlots) throws JAXRException {
        for (Object o : pSlots) {
            this.addSlot((Slot)o);
        }
    }

    public Slot getSlot(String pSlotName) throws JAXRException {
        return this.slots().get(pSlotName);
    }

    public Collection<?> getSlots() throws JAXRException {
        return this.slots().values();
    }

    public void removeSlot(String pSlotName) throws JAXRException {
        this.slots().remove(pSlotName);
    }

    public void removeSlots(Collection pSlotNames) throws JAXRException {
        for (Object o : pSlotNames) {
            this.removeSlot((String)o);
        }
    }
}

