/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.InternationalString;
import org.apache.labs.jaxmas.registry.infomodel.InternationalStringImpl;
import org.apache.labs.jaxmas.registry.infomodel.ROState;
import org.apache.labs.jaxmas.registry.infomodel.RegistryObjectImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.DbDriver;

public class InternationalStringController {
    private ROState state;
    private final InternationalStringImpl.Type type;
    private final RegistryObjectImpl<?> ro;
    private InternationalString string;

    public InternationalStringController(RegistryObjectImpl<?> pRo, InternationalStringImpl.Type pType, ROState pState) {
        this.ro = pRo;
        this.type = pType;
        this.state = pState;
    }

    public void setState(ROState pState) {
        this.state = pState;
    }

    private void ensureLoaded() throws JAXRException {
        switch (this.state) {
            case created: 
            case loaded: 
            case deleted: {
                if (this.string != null) break;
                this.string = new InternationalStringImpl();
                break;
            }
            case referenced: {
                this.string = this.getDbDriver().loadInternationalString(this.ro.getKey(), this.type);
                this.state = ROState.loaded;
            }
        }
    }

    public InternationalString getString() throws JAXRException {
        this.ensureLoaded();
        return this.string;
    }

    public void setString(InternationalString pString) throws JAXRException {
        this.ensureLoaded();
        this.string = pString;
    }

    private DbDriver getDbDriver() {
        return RegistryServiceImpl.getDbDriver(this.ro.getRegistryService());
    }

    public void save() throws JAXRException {
        switch (this.state) {
            case created: {
                this.getDbDriver().insertInternationalString(this.ro.getKey(), this.type, this.string);
                this.state = ROState.loaded;
                break;
            }
            case referenced: {
                break;
            }
            case deleted: {
                throw new IllegalStateException("Unable to save an object, which has already been deleted.");
            }
            case loaded: {
                this.getDbDriver().updateInternationalString(this.ro.getKey(), this.type, this.string);
            }
        }
    }
}

