/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.LocalizedString;
import org.apache.labs.jaxmas.registry.infomodel.LocalizedStringImpl;

public class InternationalStringImpl
implements InternationalString {
    private final Map<String, LocalizedString> localizedStrings = new HashMap<String, LocalizedString>();

    private String makeKey(Locale pLocale, String pCharsetName) {
        String charsetName = pCharsetName == null ? "UTF-8" : pCharsetName;
        Locale locale = pLocale == null ? Locale.getDefault() : pLocale;
        return locale.toString() + ":" + charsetName;
    }

    private String makeKey(LocalizedString pLocalizedString) throws JAXRException {
        return this.makeKey(pLocalizedString.getLocale(), pLocalizedString.getCharsetName());
    }

    public void addLocalizedString(LocalizedString pLocalizedString) throws JAXRException {
        this.localizedStrings.put(this.makeKey(pLocalizedString), pLocalizedString);
    }

    public void addLocalizedStrings(Collection pLocalizedStrings) throws JAXRException {
        for (Object o : pLocalizedStrings) {
            this.addLocalizedString((LocalizedString)o);
        }
    }

    public LocalizedString getLocalizedString(Locale locale, String charsetName) throws JAXRException {
        return this.localizedStrings.get(this.makeKey(locale, charsetName));
    }

    public Collection getLocalizedStrings() throws JAXRException {
        return this.localizedStrings.values();
    }

    public String getValue() throws JAXRException {
        return this.getValue(Locale.getDefault());
    }

    public String getValue(Locale locale) throws JAXRException {
        LocalizedString ls = this.localizedStrings.get(this.makeKey(locale, "UTF-8"));
        return ls == null ? null : ls.getValue();
    }

    public void removeLocalizedString(LocalizedString pLocalizedString) throws JAXRException {
        this.localizedStrings.remove(this.makeKey(pLocalizedString));
    }

    public void removeLocalizedStrings(Collection pLocalizedStrings) throws JAXRException {
        for (Object o : pLocalizedStrings) {
            this.removeLocalizedString((LocalizedString)o);
        }
    }

    public void setValue(String pValue) throws JAXRException {
        this.setValue(Locale.getDefault(), pValue);
    }

    public void setValue(Locale pLocale, String pValue) throws JAXRException {
        LocalizedStringImpl ls = new LocalizedStringImpl();
        ls.setCharsetName("UTF-8");
        ls.setLocale(pLocale == null ? Locale.getDefault() : pLocale);
        ls.setValue(pValue);
        this.addLocalizedString(ls);
    }

    public static enum Type {
        name,
        description;

    }
}

