/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import org.apache.labs.jaxmas.registry.accessor.AssociationAccessor;
import org.apache.labs.jaxmas.registry.accessor.ClassificationAccessor;
import org.apache.labs.jaxmas.registry.accessor.ConceptAccessor;
import org.apache.labs.jaxmas.registry.accessor.OrganizationAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessors;
import org.apache.labs.jaxmas.registry.infomodel.BulkResponseImpl;
import org.apache.labs.jaxmas.registry.infomodel.ClassificationSchemeImpl;
import org.apache.labs.jaxmas.registry.infomodel.ConceptImpl;
import org.apache.labs.jaxmas.registry.infomodel.EmailAddressImpl;
import org.apache.labs.jaxmas.registry.infomodel.InternationalStringImpl;
import org.apache.labs.jaxmas.registry.infomodel.KeyImpl;
import org.apache.labs.jaxmas.registry.infomodel.LocalizedStringImpl;
import org.apache.labs.jaxmas.registry.infomodel.NLSStrings;
import org.apache.labs.jaxmas.registry.infomodel.PersonNameImpl;
import org.apache.labs.jaxmas.registry.infomodel.PostalAddressImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryObjectImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.infomodel.SlotImpl;
import org.apache.labs.jaxmas.registry.infomodel.TelephoneNumberImpl;
import org.apache.labs.jaxmas.registry.infomodel.UserImpl;

public abstract class LifeCycleManagerImpl
implements LifeCycleManager {
    private final RegistryServiceImpl registryService;

    protected LifeCycleManagerImpl(RegistryServiceImpl pRegistryService) {
        this.registryService = pRegistryService;
    }

    public Association createAssociation(RegistryObject pTargetObject, Concept pAssociationType) throws JAXRException {
        Association assoc = (Association)AssociationAccessor.getInstance().create(this.getRegistryService());
        assoc.setTargetObject(pTargetObject);
        assoc.setAssociationType(pAssociationType);
        return assoc;
    }

    public Classification createClassification(ClassificationScheme pScheme, InternationalString pName, String pValue) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public Classification createClassification(ClassificationScheme pScheme, String pName, String pValue) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public Classification createClassification(Concept pConcept) throws JAXRException, InvalidRequestException {
        Classification cl = (Classification)ClassificationAccessor.getInstance().create(this.getRegistryService());
        cl.setConcept(pConcept);
        return cl;
    }

    public ClassificationScheme createClassificationScheme(Concept pConcept) throws JAXRException, InvalidRequestException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public ClassificationScheme createClassificationScheme(InternationalString pName, InternationalString pDescription) throws JAXRException, InvalidRequestException {
        ClassificationSchemeImpl cs = new ClassificationSchemeImpl(this.registryService, null);
        cs.setKey(cs.getROLoader().newKey(this.registryService));
        cs.setName(pName);
        cs.setDescription(pDescription);
        return cs;
    }

    public ClassificationScheme createClassificationScheme(String pName, String pDescription) throws JAXRException, InvalidRequestException {
        InternationalString name = pName == null ? null : this.createInternationalString(pName);
        InternationalString desc = pDescription == null ? null : this.createInternationalString(pDescription);
        return this.createClassificationScheme(name, desc);
    }

    public Concept createConcept(RegistryObject pParent, InternationalString pName, String pValue) throws JAXRException {
        Concept concept = (Concept)ConceptAccessor.getInstance().create(this.registryService);
        concept.setName(pName);
        concept.setValue(pValue);
        if (pParent instanceof ClassificationScheme) {
            ((ClassificationScheme)pParent).addChildConcept(concept);
        } else if (pParent instanceof Concept) {
            ((Concept)pParent).addChildConcept(concept);
        } else {
            throw new IllegalStateException("Invalid parent: " + pParent.getKey() + "[" + pParent.getClass().getName() + "]");
        }
        ((ConceptImpl)concept).setOwner(pParent);
        return concept;
    }

    public Concept createConcept(RegistryObject pParent, String pName, String pValue) throws JAXRException {
        InternationalString name = pName == null ? null : this.createInternationalString(pName);
        return this.createConcept(pParent, name, pValue);
    }

    public EmailAddress createEmailAddress(String pAddress, String pType) throws JAXRException {
        EmailAddressImpl ea = new EmailAddressImpl();
        ea.setType(pType);
        ea.setAddress(pAddress);
        return ea;
    }

    public EmailAddress createEmailAddress(String pAddress) throws JAXRException {
        EmailAddressImpl emailAddress = new EmailAddressImpl();
        emailAddress.setAddress(pAddress);
        return emailAddress;
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme pIdentificationScheme, InternationalString pName, String pValue) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme pIdentificationScheme, String pName, String pValue) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public ExternalLink createExternalLink(String pExternalURI, InternationalString pDescription) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public ExternalLink createExternalLink(String pExternalURI, String pDescription) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public ExtrinsicObject createExtrinsicObject(DataHandler pRepositoryItem) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public InternationalString createInternationalString() throws JAXRException {
        return new InternationalStringImpl();
    }

    public InternationalString createInternationalString(Locale pLocale, String pValue) throws JAXRException {
        InternationalString is = this.createInternationalString();
        is.setValue(pLocale, pValue);
        return is;
    }

    public InternationalString createInternationalString(String pValue) throws JAXRException {
        InternationalString is = this.createInternationalString();
        is.setValue(pValue);
        return is;
    }

    public Key createKey(String pId) throws JAXRException {
        KeyImpl key = new KeyImpl();
        key.setId(pId);
        return key;
    }

    public LocalizedString createLocalizedString(Locale pLocale, String pValue) throws JAXRException {
        LocalizedStringImpl ls = new LocalizedStringImpl();
        ls.setLocale(pLocale);
        ls.setValue(pValue);
        return ls;
    }

    public LocalizedString createLocalizedString(Locale pLocale, String pValue, String pCharsetName) throws JAXRException {
        LocalizedString ls = this.createLocalizedString(pLocale, pValue);
        ls.setCharsetName(pCharsetName);
        return ls;
    }

    public Object createObject(String pInterfaceName) throws JAXRException, InvalidRequestException, UnsupportedCapabilityException {
        ROAccessor<?> roAcc = ROAccessors.getROAccessor(pInterfaceName);
        if (roAcc == null) {
            if ("EmailAddress".equals(pInterfaceName)) {
                return new EmailAddressImpl();
            }
            if ("InternationalString".equals(pInterfaceName)) {
                return this.createInternationalString();
            }
            if ("Key".equals(pInterfaceName)) {
                return ConceptAccessor.getInstance().newKey(this.getRegistryService());
            }
            if ("LocalizedString".equals(pInterfaceName)) {
                LocalizedStringImpl ls = new LocalizedStringImpl();
                ls.setLocale(Locale.getDefault());
                return ls;
            }
            if ("PersonName".equals(pInterfaceName)) {
                return new PersonNameImpl();
            }
            if ("Slot".equals(pInterfaceName)) {
                return new SlotImpl();
            }
            if ("TelephoneNumber".equals(pInterfaceName)) {
                return new TelephoneNumberImpl();
            }
            if ("Versionable".equals(pInterfaceName) || "RegistryEntry".equals(pInterfaceName)) {
                return ROAccessors.getROAccessor(ROAccessors.ObjectTypes.REGISTRY_ENTRY).create(this.getRegistryService());
            }
            throw new UnsupportedCapabilityException("Not implemented: " + pInterfaceName);
        }
        return roAcc.create(this.getRegistryService());
    }

    public Organization createOrganization(InternationalString pName) throws JAXRException {
        Organization org = (Organization)OrganizationAccessor.getInstance().create(this.getRegistryService());
        org.setName(pName);
        return org;
    }

    public Organization createOrganization(String pName) throws JAXRException {
        return this.createOrganization(this.createInternationalString(pName));
    }

    public PersonName createPersonName(String pFullName) throws JAXRException {
        PersonNameImpl pn = new PersonNameImpl();
        pn.setFullName(pFullName);
        return pn;
    }

    public PersonName createPersonName(String pFirstName, String pMiddleName, String pLastName) throws JAXRException {
        PersonNameImpl pn = new PersonNameImpl();
        pn.setFirstName(pFirstName);
        pn.setMiddleName(pMiddleName);
        pn.setLastName(pLastName);
        return pn;
    }

    public PostalAddress createPostalAddress(String pStreetNumber, String pStreet, String pCity, String pStateOrProvince, String pCountry, String pPostalCode, String pType) throws JAXRException {
        PostalAddressImpl pa = new PostalAddressImpl((RegistryServiceImpl)this.getRegistryService());
        pa.setStreetNumber(pStreetNumber);
        pa.setStreet(pStreet);
        pa.setCity(pCity);
        pa.setStateOrProvince(pStateOrProvince);
        pa.setCountry(pCountry);
        pa.setPostalCode(pPostalCode);
        pa.setType(pType);
        return pa;
    }

    public RegistryPackage createRegistryPackage(InternationalString pName) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public RegistryPackage createRegistryPackage(String pName) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public Service createService(InternationalString pName) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public Service createService(String pName) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public ServiceBinding createServiceBinding() throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public Slot createSlot(String pName, Collection pValues, String pSlotType) throws JAXRException {
        SlotImpl slot = new SlotImpl();
        slot.setName(pName);
        slot.setSlotType(pSlotType);
        slot.setValues(pValues);
        return slot;
    }

    public Slot createSlot(String pName, String pValue, String pSlotType) throws JAXRException {
        return this.createSlot(pName, Collections.singleton(pValue), pSlotType);
    }

    public SpecificationLink createSpecificationLink() throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public TelephoneNumber createTelephoneNumber() throws JAXRException {
        return new TelephoneNumberImpl();
    }

    public User createUser() throws JAXRException {
        return new UserImpl(this.registryService, null);
    }

    public BulkResponse deleteObjects(Collection pKeys, String pObjectType) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public BulkResponse deleteObjects(Collection pKeys) throws JAXRException {
        for (Object o : pKeys) {
            Key key = (Key)o;
            RegistryObject ro = this.getRegistryService().getBusinessQueryManager().getRegistryObject(key.getId());
            ((RegistryObjectImpl)ro).getROLoader().remove(this.getRegistryService(), ro);
        }
        return new BulkResponseImpl(pKeys);
    }

    public BulkResponse deprecateObjects(Collection pKeys) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public RegistryService getRegistryService() throws JAXRException {
        return this.registryService;
    }

    protected void saveObject(RegistryObject pObject) throws JAXRException {
        if (pObject == null) {
            throw new IllegalArgumentException(this.getNLSStrings().format("NULL_PARAMETER", "pObject"));
        }
        ((RegistryObjectImpl)pObject).getROLoader().save(this.getRegistryService(), pObject);
    }

    public BulkResponse saveObjects(Collection pObjects) throws JAXRException {
        if (pObjects == null) {
            throw new IllegalArgumentException(this.getNLSStrings().format("NULL_PARAMETER", "pObjects"));
        }
        ArrayList keys = new ArrayList();
        for (Object o : pObjects) {
            this.saveObject((RegistryObject)o);
        }
        return new BulkResponseImpl(keys);
    }

    public BulkResponse unDeprecateObjects(Collection pKeys) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    protected Locale getLocale() {
        return this.registryService.getConnection().getLocale();
    }

    protected NLSStrings getNLSStrings() {
        return this.registryService.getConnection().getNLSStrings();
    }
}

