/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class NLSStrings {
    private static final Map<Locale, ResourceBundle> bundles = new HashMap<Locale, ResourceBundle>();
    public static final String OPERATION_NOT_IMPLEMENTED = "OPERATION_NOT_IMPLEMENTED";
    public static final String PROPERTY_NOT_SET = "PROPERTY_NOT_SET";
    public static final String NULL_PARAMETER = "NULL_PARAMETER";
    public static final String UNSUPPORTED_PARAMETER = "UNSUPPORTED_PARAMETER";
    public static final String CONCEPT_PARENT_MISSING = "CONCEPT_PARENT_MISSING";
    public static final String CONCEPT_VALUE_MISSING = "CONCEPT_VALUE_MISSING";
    public static final String MULTIPLE_INSTANCES_FOUND = "MULTIPLE_INSTANCES_FOUND";
    private final Locale locale;
    private final ResourceBundle bundle;

    private String getPackageName() {
        String className = NLSStrings.class.getName();
        int offset = className.lastIndexOf(46);
        if (offset == -1) {
            throw new IllegalStateException("Failed to parse package name: " + className);
        }
        return className.substring(0, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NLSStrings(Locale pLocale) {
        ResourceBundle myBundle;
        Map<Locale, ResourceBundle> map = bundles;
        synchronized (map) {
            myBundle = bundles.get(pLocale);
            if (myBundle == null) {
                myBundle = ResourceBundle.getBundle(this.getPackageName().replace('.', '/') + "/NLSStrings", pLocale);
                bundles.put(pLocale, myBundle);
            }
        }
        this.bundle = myBundle;
        this.locale = pLocale;
    }

    public String get(String pKey) {
        return (String)this.bundle.getObject(pKey);
    }

    public String format(String pKey, Object ... pArgs) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format(this.get(pKey), pArgs);
        return sb.toString();
    }

    public Locale getLocale() {
        return this.locale;
    }
}

