/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.labs.jaxmas.registry.infomodel.RegistryObjectImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;

public abstract class OwnedRegistryObject<RO extends RegistryObject>
extends RegistryObjectImpl<RO> {
    private Key ownerKey;
    private RegistryObject owner;
    private int position;

    public abstract boolean isRestricting();

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int pPosition) {
        this.position = pPosition;
    }

    public OwnedRegistryObject(RegistryServiceImpl pRegistryService, Key pKey) {
        super(pRegistryService, pKey);
    }

    public void setOwner(RegistryObject pOwner) throws JAXRException {
        this.ensureLoaded();
        this.owner = pOwner;
        this.ownerKey = pOwner == null ? null : pOwner.getKey();
    }

    public void setOwner(Key pOwner) throws JAXRException {
        this.ensureLoaded();
        if (pOwner == null) {
            this.owner = null;
        } else if (this.owner != null && !this.owner.getKey().equals(pOwner)) {
            this.owner = null;
        }
        this.ownerKey = pOwner;
    }

    public RegistryObject getOwner() throws JAXRException {
        this.ensureLoaded();
        if (this.owner == null && this.ownerKey != null) {
            BusinessQueryManager bqm = this.getRegistryService().getBusinessQueryManager();
            this.owner = bqm.getRegistryObject(this.ownerKey.getId());
            assert (this.owner != null);
        }
        return this.owner;
    }
}

