/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.QueryManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.labs.jaxmas.registry.infomodel.BulkResponseImpl;
import org.apache.labs.jaxmas.registry.infomodel.KeyImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.KeyPredicate;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectLoader;

public abstract class QueryManagerImpl
implements QueryManager {
    private static final RegistryObjectLoader rol;
    private final RegistryServiceImpl registryService;

    protected QueryManagerImpl(RegistryServiceImpl pRegistryService) {
        this.registryService = pRegistryService;
    }

    public RegistryObject getRegistryObject(String pId) throws JAXRException {
        KeyPredicate predicate = new KeyPredicate(Collections.singleton(new KeyImpl(pId)));
        return rol.getResultObject(this.getRegistryService(), Collections.singleton(predicate));
    }

    public RegistryObject getRegistryObject(String pId, String pObjectType) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public BulkResponse getRegistryObjects() throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public BulkResponse getRegistryObjects(Collection pObjectKeys) throws JAXRException {
        KeyPredicate predicate = new KeyPredicate(pObjectKeys);
        List<RegistryObject> list = rol.getResultList(this.getRegistryService(), Collections.singleton(predicate), null);
        return new BulkResponseImpl(list);
    }

    public BulkResponse getRegistryObjects(String pObjectTypes) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public BulkResponse getRegistryObjects(Collection pObjectKeys, String pObjectTypes) throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public RegistryService getRegistryService() throws JAXRException {
        return this.registryService;
    }

    static {
        try {
            rol = new RegistryObjectLoader(null, null, null);
        }
        catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

