/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Date;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryEntry;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessors;
import org.apache.labs.jaxmas.registry.accessor.RegistryEntryAccessor;
import org.apache.labs.jaxmas.registry.infomodel.RegistryObjectImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;

public class RegistryEntryImpl<RE extends RegistryEntry>
extends RegistryObjectImpl<RE>
implements RegistryEntry {
    private Date expiration;
    private int stability;
    private int majorVersion;
    private int minorVersion;
    private int status;
    private String userVersion;
    private String customType;
    private Concept customTypeObject;

    public RegistryEntryImpl(RegistryServiceImpl pRegistryService, Key pKey) {
        super(pRegistryService, pKey);
    }

    public Date getExpiration() throws JAXRException {
        this.ensureLoaded();
        return this.expiration;
    }

    public int getStability() throws JAXRException {
        this.ensureLoaded();
        return this.stability;
    }

    public int getStatus() throws JAXRException {
        this.ensureLoaded();
        return this.status;
    }

    public void setExpiration(Date pExpiration) throws JAXRException {
        this.ensureLoaded();
        this.expiration = pExpiration;
    }

    public void setStability(int pStability) throws JAXRException {
        this.ensureLoaded();
        this.stability = pStability;
    }

    public int getMajorVersion() throws JAXRException {
        this.ensureLoaded();
        return this.majorVersion;
    }

    public int getMinorVersion() throws JAXRException {
        this.ensureLoaded();
        return this.minorVersion;
    }

    public String getUserVersion() throws JAXRException {
        this.ensureLoaded();
        return this.userVersion;
    }

    public void setMajorVersion(int pVersion) throws JAXRException {
        this.ensureLoaded();
        this.majorVersion = pVersion;
    }

    public void setMinorVersion(int pVersion) throws JAXRException {
        this.ensureLoaded();
        this.minorVersion = pVersion;
    }

    public void setUserVersion(String pVersion) throws JAXRException {
        this.ensureLoaded();
        this.userVersion = pVersion;
    }

    @Override
    public ROAccessor<RE> getROLoader() {
        return RegistryEntryAccessor.getInstance();
    }

    public String getCustomType() throws JAXRException {
        this.ensureLoaded();
        return this.customType;
    }

    public void setCustomType(String pCustomType) throws JAXRException {
        this.ensureLoaded();
        this.customType = pCustomType;
        this.customTypeObject = null;
    }

    @Override
    public void addClassification(Classification pClassification) throws JAXRException {
        Concept concept = pClassification.getConcept();
        if (concept.getParent().getKey().getId().equals(ROAccessors.ClassificationSchemes.OBJECT_TYPE.getId())) {
            this.setCustomType(concept.getKey().getId());
        } else {
            super.addClassification(pClassification);
        }
    }

    @Override
    public Concept getObjectType() throws JAXRException {
        String type = this.getCustomType();
        if (type == null) {
            return super.getObjectType();
        }
        if (this.customTypeObject == null) {
            this.customTypeObject = (Concept)this.getRegistryService().getBusinessQueryManager().getRegistryObject(type);
        }
        return this.customTypeObject;
    }
}

