/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Slot;
import org.apache.labs.jaxmas.registry.accessor.AssociationAccessor;
import org.apache.labs.jaxmas.registry.accessor.ClassificationAccessor;
import org.apache.labs.jaxmas.registry.accessor.ConceptAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessors;
import org.apache.labs.jaxmas.registry.infomodel.AssociationImpl;
import org.apache.labs.jaxmas.registry.infomodel.ClassificationImpl;
import org.apache.labs.jaxmas.registry.infomodel.ConnectionImpl;
import org.apache.labs.jaxmas.registry.infomodel.ExtensibleObjectImpl;
import org.apache.labs.jaxmas.registry.infomodel.InternationalStringController;
import org.apache.labs.jaxmas.registry.infomodel.InternationalStringImpl;
import org.apache.labs.jaxmas.registry.infomodel.KeyImpl;
import org.apache.labs.jaxmas.registry.infomodel.NLSStrings;
import org.apache.labs.jaxmas.registry.infomodel.ROState;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.AssociationNumOrderPredicate;
import org.apache.labs.jaxmas.registry.sql.ClassificationNumOrderPredicate;
import org.apache.labs.jaxmas.registry.sql.FilterPredicate;
import org.apache.labs.jaxmas.registry.sql.OrderPredicate;
import org.apache.labs.jaxmas.registry.sql.OwnerPredicate;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectLoader;

public abstract class RegistryObjectImpl<RO extends RegistryObject>
extends ExtensibleObjectImpl
implements RegistryObject {
    private ROState state = ROState.created;
    private LifeCycleManager lifeCycleManager;
    private final InternationalStringController name;
    private final InternationalStringController description;
    private Key key;
    private List<Association> associations;
    private Collection<Key> loadedClassificationKeys;
    private Collection<Key> loadedAssociationKeys;
    private List<Classification> classifications;
    private Collection<ExternalIdentifier> externalIdentifiers = new ArrayList<ExternalIdentifier>();
    private Collection<ExternalLink> externalLinks = new ArrayList<ExternalLink>();

    public boolean equals(Object pObj) {
        if (pObj != null && pObj.getClass() == this.getClass()) {
            try {
                return ((RegistryObject)pObj).getKey().equals(this.getKey());
            }
            catch (JAXRException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getKey().hashCode();
        }
        catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public RegistryObjectImpl(RegistryServiceImpl pRegistryService, Key pKey) {
        super(pRegistryService);
        this.key = pKey;
        this.state = pKey == null ? ROState.created : ROState.referenced;
        this.name = new InternationalStringController(this, InternationalStringImpl.Type.name, this.state);
        this.description = new InternationalStringController(this, InternationalStringImpl.Type.description, this.state);
    }

    public ROState getState() {
        return this.state;
    }

    public void setState(ROState pState) {
        this.state = pState;
    }

    protected void ensureLoaded() throws JAXRException {
        switch (this.state) {
            case created: 
            case loaded: 
            case deleted: {
                break;
            }
            case referenced: {
                this.getROLoader().load(this.getRegistryService(), this);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state: " + (Object)((Object)this.state));
            }
        }
    }

    public abstract ROAccessor<RO> getROLoader();

    @Override
    protected Map<String, Slot> loadSlots() throws JAXRException {
        ROAccessor<RegistryObjectImpl> roLoader = this.getROLoader();
        RegistryObjectImpl ro = this;
        return roLoader.getSlots(this.getRegistryService(), ro);
    }

    public Key getKey() throws JAXRException {
        return this.key;
    }

    public void setKey(Key pKey) throws JAXRException {
        this.key = pKey;
    }

    public void addAssociation(Association pAssociation) throws JAXRException {
        this.ensureAssociationsLoaded();
        pAssociation.setSourceObject((RegistryObject)this);
        ((AssociationImpl)pAssociation).setNum(this.associations.size());
        this.associations.add(pAssociation);
    }

    public void addAssociations(Collection pAssociations) throws JAXRException {
        for (Object o : pAssociations) {
            this.addAssociation((Association)o);
        }
    }

    private void ensureClassificationsLoaded() throws JAXRException {
        if (this.classifications == null) {
            this.classifications = new ArrayList<Classification>();
            switch (this.getState()) {
                case created: {
                    break;
                }
                case loaded: 
                case referenced: {
                    Set<FilterPredicate> predicates = Collections.singleton(new OwnerPredicate(this.getKey(), false));
                    Set<OrderPredicate> orderPredicates = Collections.singleton(ClassificationNumOrderPredicate.getInstance());
                    RegistryObjectLoader rol = ClassificationAccessor.getInstance().getRegistryObjectLoader();
                    this.loadedClassificationKeys = new HashSet<Key>();
                    List<RegistryObject> storedClassifications = rol.getResultList((RegistryService)this.getRegistryService(), predicates, orderPredicates);
                    for (RegistryObject ro : storedClassifications) {
                        this.loadedClassificationKeys.add(ro.getKey());
                    }
                    this.addClassifications(storedClassifications);
                    break;
                }
            }
            if (this.loadedClassificationKeys == null) {
                this.loadedClassificationKeys = new HashSet<Key>();
            }
        }
    }

    private void ensureAssociationsLoaded() throws JAXRException {
        if (this.associations == null) {
            this.associations = new ArrayList<Association>();
            switch (this.getState()) {
                case created: {
                    break;
                }
                case loaded: 
                case referenced: {
                    Set<FilterPredicate> filterPredicates = Collections.singleton(new OwnerPredicate(this.getKey(), false));
                    Set<OrderPredicate> orderPredicates = Collections.singleton(AssociationNumOrderPredicate.getInstance());
                    RegistryObjectLoader rol = AssociationAccessor.getInstance().getRegistryObjectLoader();
                    this.loadedAssociationKeys = new HashSet<Key>();
                    List<RegistryObject> storedAssociations = rol.getResultList((RegistryService)this.getRegistryService(), filterPredicates, orderPredicates);
                    for (RegistryObject ro : storedAssociations) {
                        this.loadedAssociationKeys.add(ro.getKey());
                    }
                    this.addAssociations(storedAssociations);
                    break;
                }
            }
            if (this.loadedAssociationKeys == null) {
                this.loadedAssociationKeys = new HashSet<Key>();
            }
        }
    }

    public void addClassification(Classification pClassification) throws JAXRException {
        this.ensureClassificationsLoaded();
        pClassification.setClassifiedObject((RegistryObject)this);
        ((ClassificationImpl)pClassification).setNum(this.classifications.size());
        this.classifications.add(pClassification);
    }

    public void addClassifications(Collection pClassifications) throws JAXRException {
        for (Object o : pClassifications) {
            this.addClassification((Classification)o);
        }
    }

    public void addExternalIdentifier(ExternalIdentifier pExternalIdentifier) throws JAXRException {
        this.externalIdentifiers.add(pExternalIdentifier);
    }

    public void addExternalIdentifiers(Collection pExternalIdentifiers) throws JAXRException {
        for (Object o : pExternalIdentifiers) {
            this.addExternalIdentifier((ExternalIdentifier)o);
        }
    }

    public void addExternalLink(ExternalLink pExternalLink) throws JAXRException {
        this.externalLinks.add(pExternalLink);
    }

    public void addExternalLinks(Collection pExternalLinks) throws JAXRException {
        for (Object o : pExternalLinks) {
            this.addExternalLink((ExternalLink)o);
        }
    }

    public Collection getAssociatedObjects() throws JAXRException {
        HashSet<RegistryObject> targets = new HashSet<RegistryObject>();
        for (Object o : this.getAssociations()) {
            targets.add(((Association)o).getTargetObject());
        }
        return targets;
    }

    public Collection getAssociations() throws JAXRException {
        this.ensureAssociationsLoaded();
        return this.associations;
    }

    public Collection getAuditTrail() throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public Collection getClassifications() throws JAXRException {
        this.ensureClassificationsLoaded();
        return this.classifications;
    }

    public InternationalString getDescription() throws JAXRException {
        return this.description.getString();
    }

    public Collection getExternalIdentifiers() throws JAXRException {
        return this.externalIdentifiers;
    }

    public Collection getExternalLinks() throws JAXRException {
        return this.externalLinks;
    }

    public LifeCycleManager getLifeCycleManager() throws JAXRException {
        return this.lifeCycleManager;
    }

    public InternationalString getName() throws JAXRException {
        return this.name.getString();
    }

    public Collection getRegistryPackages() throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public Organization getSubmittingOrganization() throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public void removeAssociation(Association pAssociation) throws JAXRException {
        this.ensureAssociationsLoaded();
        this.associations.remove(pAssociation);
    }

    public void removeAssociations(Collection pAssociations) throws JAXRException {
        for (Object o : pAssociations) {
            this.removeAssociation((Association)o);
        }
    }

    public void removeClassification(Classification classification) throws JAXRException {
        this.ensureClassificationsLoaded();
        this.classifications.remove(classification);
    }

    public void removeClassifications(Collection pClassifications) throws JAXRException {
        for (Object o : pClassifications) {
            this.removeClassification((Classification)o);
        }
    }

    public void removeExternalIdentifier(ExternalIdentifier pExternalIdentifier) throws JAXRException {
        this.externalIdentifiers.remove(pExternalIdentifier);
    }

    public void removeExternalIdentifiers(Collection pExternalIdentifiers) throws JAXRException {
        for (Object o : pExternalIdentifiers) {
            this.removeExternalIdentifier((ExternalIdentifier)o);
        }
    }

    public void removeExternalLink(ExternalLink pExternalLink) throws JAXRException {
        this.externalLinks.remove(pExternalLink);
    }

    public void removeExternalLinks(Collection pExternalLinks) throws JAXRException {
        for (Object o : pExternalLinks) {
            this.removeExternalLink((ExternalLink)o);
        }
    }

    public void setAssociations(Collection pAssociations) throws JAXRException {
        this.ensureAssociationsLoaded();
        this.associations.clear();
        int i = 0;
        for (Object o : pAssociations) {
            AssociationImpl assoc = (AssociationImpl)o;
            assoc.setNum(i++);
            this.associations.add(assoc);
        }
    }

    public void setClassifications(Collection pClassifications) throws JAXRException {
        this.ensureClassificationsLoaded();
        this.classifications.clear();
        int i = 0;
        for (Object o : pClassifications) {
            ClassificationImpl cl = (ClassificationImpl)o;
            cl.setNum(i++);
            this.classifications.add(cl);
        }
    }

    public void setDescription(InternationalString pDescription) throws JAXRException {
        this.description.setString(pDescription);
    }

    public void setExternalIdentifiers(Collection pExternalIdentifiers) throws JAXRException {
        if (pExternalIdentifiers == null) {
            this.externalIdentifiers.clear();
        } else {
            this.externalIdentifiers = pExternalIdentifiers;
        }
    }

    public void setExternalLinks(Collection pExternalLinks) throws JAXRException {
        if (pExternalLinks == null) {
            this.externalLinks.clear();
        } else {
            this.externalLinks = pExternalLinks;
        }
    }

    public void setName(InternationalString pName) throws JAXRException {
        this.name.setString(pName);
    }

    public String toXML() throws JAXRException {
        throw new JAXRException("OPERATION_NOT_IMPLEMENTED");
    }

    public Concept getObjectType() throws JAXRException {
        this.ensureLoaded();
        if (this.getKey().getId().equals(ROAccessors.ObjectTypes.CONCEPT.getId())) {
            return (Concept)this;
        }
        ROAccessors.ObjectTypes type = ROAccessors.ObjectTypes.values()[this.getROLoader().getRegistryObjectType()];
        return (Concept)ConceptAccessor.getInstance().create(this.getRegistryService(), new KeyImpl(type.getId()));
    }

    protected Locale getLocale() {
        return ConnectionImpl.getLocale(this.getRegistryService().getConnection());
    }

    protected NLSStrings getNLSStrings() {
        return ConnectionImpl.getNLSStrings(this.getRegistryService().getConnection());
    }

    public InternationalStringController getNameController() {
        return this.name;
    }

    public InternationalStringController getDescriptionController() {
        return this.description;
    }

    public void setLoadedClassificationKeys(Collection<Key> loadedClassificationKeys) {
        this.loadedClassificationKeys = loadedClassificationKeys;
    }

    public Collection<Key> getLoadedClassificationKeys() {
        return this.loadedClassificationKeys;
    }

    public void setLoadedAssociationKeys(Collection<Key> loadedAssociationKeys) {
        this.loadedAssociationKeys = loadedAssociationKeys;
    }

    public Collection<Key> getLoadedAssociationKeys() {
        return this.loadedAssociationKeys;
    }
}

