/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;
import org.apache.labs.jaxmas.registry.accessor.RegistryPackageAccessor;
import org.apache.labs.jaxmas.registry.infomodel.RegistryEntryImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;

public class RegistryPackageImpl
extends RegistryEntryImpl<RegistryPackage>
implements RegistryPackage {
    private Collection<RegistryObject> registryObjects = new HashSet<RegistryObject>();

    public RegistryPackageImpl(RegistryServiceImpl pRegistryService, Key pKey) {
        super(pRegistryService, pKey);
    }

    @Override
    public ROAccessor<RegistryPackage> getROLoader() {
        return RegistryPackageAccessor.getInstance();
    }

    public void addRegistryObject(RegistryObject pRegistryObject) throws JAXRException {
        if (pRegistryObject == null) {
            throw new IllegalArgumentException(this.getNLSStrings().format("NULL_PARAMETER", "pRegistryObject"));
        }
        this.registryObjects.add(pRegistryObject);
    }

    public void addRegistryObjects(Collection pRegistryObjects) throws JAXRException {
        if (pRegistryObjects == null) {
            throw new IllegalArgumentException(this.getNLSStrings().format("NULL_PARAMETER", "pRegistryObjects"));
        }
        for (Object o : pRegistryObjects) {
            this.addRegistryObject((RegistryObject)o);
        }
    }

    public Set getRegistryObjects() throws JAXRException {
        return Collections.unmodifiableSet((Set)this.registryObjects);
    }

    public void removeRegistryObject(RegistryObject pRegistryObject) throws JAXRException {
        if (pRegistryObject == null) {
            throw new IllegalArgumentException(this.getNLSStrings().format("NULL_PARAMETER", "pRegistryObject"));
        }
        this.registryObjects.remove(pRegistryObject);
    }

    public void removeRegistryObjects(Collection pRegistryObjects) throws JAXRException {
        if (pRegistryObjects == null) {
            throw new IllegalArgumentException(this.getNLSStrings().format("NULL_PARAMETER", "pRegistryObjects"));
        }
        for (Object o : pRegistryObjects) {
            this.removeRegistryObject((RegistryObject)o);
        }
    }
}

