/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.sql.SQLException;
import java.util.Locale;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import org.apache.labs.jaxmas.registry.infomodel.BusinessLifeCycleManagerImpl;
import org.apache.labs.jaxmas.registry.infomodel.BusinessQueryManagerImpl;
import org.apache.labs.jaxmas.registry.infomodel.CapabilityProfileImpl;
import org.apache.labs.jaxmas.registry.infomodel.ConnectionImpl;
import org.apache.labs.jaxmas.registry.infomodel.DeclarativeQueryManagerImpl;
import org.apache.labs.jaxmas.registry.infomodel.NLSStrings;
import org.apache.labs.jaxmas.registry.sql.DbDriver;
import org.apache.labs.jaxmas.registry.sql.DerbyDbDriver;
import org.apache.labs.jaxmas.registry.sql.HsqlDbDriver;

public class RegistryServiceImpl
implements RegistryService {
    private final ConnectionImpl connection;
    private final BusinessLifeCycleManager blm = new BusinessLifeCycleManagerImpl(this);
    private final BusinessQueryManager bqm = new BusinessQueryManagerImpl(this);
    private final DeclarativeQueryManager dqm = new DeclarativeQueryManagerImpl(this);
    private final DbDriver dbDriver;

    public RegistryServiceImpl(ConnectionImpl pConnection) throws SQLException {
        this.connection = pConnection;
        String databaseProductName = pConnection.getConnection().getMetaData().getDatabaseProductName();
        if ("Apache Derby".equals(databaseProductName)) {
            this.dbDriver = new DerbyDbDriver(this);
        } else if ("HSQL Database Engine".equals(databaseProductName)) {
            this.dbDriver = new HsqlDbDriver(this);
        } else {
            throw new IllegalStateException("Invalid database product name: " + databaseProductName);
        }
    }

    public BulkResponse getBulkResponse(String pRequestId) throws JAXRException, InvalidRequestException {
        throw new IllegalStateException("Not implemented");
    }

    public BusinessLifeCycleManager getBusinessLifeCycleManager() throws JAXRException {
        return this.blm;
    }

    public BusinessQueryManager getBusinessQueryManager() throws JAXRException {
        return this.bqm;
    }

    public CapabilityProfile getCapabilityProfile() throws JAXRException {
        return CapabilityProfileImpl.getInstance();
    }

    public DeclarativeQueryManager getDeclarativeQueryManager() throws JAXRException, UnsupportedCapabilityException {
        return this.dqm;
    }

    public ClassificationScheme getDefaultPostalScheme() throws JAXRException {
        return null;
    }

    public String makeRegistrySpecificRequest(String pRequest) throws JAXRException {
        throw new IllegalStateException("Not implemented");
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public static Locale getLocale(RegistryService pRegistryService) {
        return ((RegistryServiceImpl)pRegistryService).getConnection().getLocale();
    }

    public static NLSStrings getNLSStrings(RegistryService pRegistryService) {
        return ((RegistryServiceImpl)pRegistryService).getConnection().getNLSStrings();
    }

    public static DbDriver getDbDriver(RegistryService pRegistryService) {
        return ((RegistryServiceImpl)pRegistryService).getDbDriver();
    }

    public DbDriver getDbDriver() {
        return this.dbDriver;
    }
}

