/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.schema;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import org.apache.labs.jaxmas.registry.infomodel.ConnectionImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.schema.MacroProcessor;
import org.apache.labs.jaxmas.registry.schema.SchemaUpdater;
import org.apache.labs.jaxmas.registry.sql.DbDriver;
import org.apache.labs.jaxmas.registry.util.DefaultLoggerFactory;
import org.apache.labs.jaxmas.registry.util.Logger;
import org.apache.labs.jaxmas.registry.util.Strings;

public class DbInitializer {
    private static final Logger log = DefaultLoggerFactory.getInstance().newLogger(DbInitializer.class);
    private ConnectionImpl connection;

    public DbInitializer(ConnectionImpl pConnection) {
        this.connection = pConnection;
    }

    protected ConnectionImpl getConnection() {
        return this.connection;
    }

    protected RegistryService getRegistryService() throws JAXRException {
        return this.connection.getRegistryService();
    }

    protected DbDriver getDbDriver() throws JAXRException {
        return ((RegistryServiceImpl)this.getRegistryService()).getDbDriver();
    }

    private boolean endsWithSemicolon(CharSequence pCharSequence) {
        for (int i = pCharSequence.length() - 1; i >= 0; --i) {
            char c = pCharSequence.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == ';';
        }
        return false;
    }

    private String replaceProperties(String pCommand) throws JAXRException {
        String command = pCommand;
        int offset;
        while ((offset = command.indexOf("${")) != -1) {
            int end = command.indexOf(125, offset + 2);
            if (offset == -1) {
                throw new IllegalStateException("Failed to parse command: " + command);
            }
            String property = command.substring(offset + 2, end);
            command = command.substring(0, offset) + this.getDbDriver().getDbProperty(property) + command.substring(end + 1);
        }
        return command;
    }

    protected void sql(Connection pConnection, String pCommand) throws SQLException, JAXRException {
        String mName = "sql";
        if (Strings.isTrimmedEmpty(pCommand)) {
            return;
        }
        String command = this.replaceProperties(pCommand);
        int offset = command.lastIndexOf(59);
        String cmd = command.substring(0, offset);
        log.debug("sql", cmd);
        PreparedStatement stmt = null;
        try {
            stmt = pConnection.prepareStatement(cmd);
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
        }
        catch (SQLException e) {
            if (RegistryServiceImpl.getDbDriver(this.connection.getRegistryService()).isUnknownTableError(e)) {
                return;
            }
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void initialize(Connection pConnection, BufferedReader pReader) throws IOException, SQLException, JAXRException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            String s;
            if ((s = pReader.readLine()) == null) {
                this.sql(pConnection, sb.toString());
                return;
            }
            if (s.trim().startsWith("--")) continue;
            sb.append(s);
            sb.append('\n');
            if (!this.endsWithSemicolon(sb)) continue;
            this.sql(pConnection, sb.toString());
            sb.setLength(0);
        }
    }

    protected void initialize(SchemaUpdater pSchemaUpdater, URL pSchemaFile) throws JAXRException {
        Connection conn = this.connection.getConnection();
        InputStream stream = null;
        Reader reader = null;
        BufferedReader bReader = null;
        try {
            conn.setAutoCommit(false);
            stream = pSchemaFile.openStream();
            reader = new InputStreamReader(stream, "UTF-8");
            bReader = new BufferedReader(MacroProcessor.newInstance(reader));
            if (pSchemaUpdater != null) {
                pSchemaUpdater.beforeUpdate(conn, this.connection.getRegistryService());
            }
            this.initialize(conn, bReader);
            if (pSchemaUpdater != null) {
                pSchemaUpdater.afterUpdate(conn, this.connection.getRegistryService());
            }
            bReader.close();
            bReader = null;
            reader.close();
            reader = null;
            stream.close();
            stream = null;
            conn.commit();
            conn = null;
        }
        catch (IOException e) {
            throw new JAXRException((Throwable)e);
        }
        catch (SQLException e) {
            throw new JAXRException((Throwable)e);
        }
        finally {
            if (bReader != null) {
                try {
                    bReader.close();
                }
                catch (Throwable t) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable t) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Throwable t) {}
            }
        }
    }

    private String getSchemaUpdaterClassName(int pNum) {
        String className = this.getClass().getName();
        int offset = className.lastIndexOf(46);
        if (offset == -1) {
            throw new IllegalStateException("Failed to parse package name: " + className);
        }
        return className.substring(0, offset) + ".SchemaUpdater" + pNum;
    }

    private SchemaUpdater getSchemaUpdater(int pNum) throws JAXRException {
        Class<?> cl;
        try {
            cl = Class.forName(this.getSchemaUpdaterClassName(pNum + 1));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            return (SchemaUpdater)cl.newInstance();
        }
        catch (InstantiationException e) {
            throw new JAXRException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public void initialize() throws JAXRException {
        URL url;
        int schemaVersion;
        int i = schemaVersion = this.getDbDriver().getSchemaVersion();
        while ((url = this.getClass().getResource("schema-update." + (i + 1) + ".sql")) != null) {
            this.initialize(this.getSchemaUpdater(i), url);
            ++i;
        }
    }
}

