/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.schema;

import java.io.FilterReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MacroProcessor
extends FilterReader {
    private LineCountingReader lcr;
    private final Map<String, String[]> macros = new HashMap<String, String[]>();

    public static MacroProcessor newInstance(Reader pReader) {
        LineCountingReader lcr = new LineCountingReader(pReader);
        MacroProcessor mp = new MacroProcessor(lcr);
        mp.lcr = lcr;
        return mp;
    }

    private MacroProcessor(Reader pReader) {
        super(new PushbackReader(pReader, 8192));
    }

    private String processUnescapedParameter() throws IOException {
        StringBuilder sb = new StringBuilder();
        block6: while (true) {
            int c = super.read();
            switch (c) {
                case -1: {
                    throw new IllegalStateException(this.lcr.format("Unexpected EOF in input stream."));
                }
                case 44: 
                case 125: {
                    ((PushbackReader)this.in).unread(c);
                    return sb.toString();
                }
                case 34: 
                case 39: {
                    throw new IllegalStateException(this.lcr.format("Invalid character in input stream."));
                }
                case 92: {
                    int c1 = super.read();
                    if (c1 == -1) {
                        throw new IllegalStateException(this.lcr.format("Unexpected EOF in input stream."));
                    }
                    if (c1 >= 48 && c1 <= 57) {
                        sb.append((char)c);
                    }
                    sb.append((char)c1);
                    continue block6;
                }
            }
            if (Character.isWhitespace(c)) {
                return sb.toString();
            }
            sb.append((char)c);
        }
    }

    private String processEscapedParameter(int pTerminator) throws IOException {
        StringBuilder sb = new StringBuilder();
        block4: while (true) {
            int c = super.read();
            switch (c) {
                case -1: {
                    throw new IllegalStateException(this.lcr.format("Unexpected EOF in input stream."));
                }
                case 92: {
                    int c1 = super.read();
                    if (c1 == -1) {
                        throw new IllegalStateException(this.lcr.format("Unexpected EOF in input stream."));
                    }
                    if (c1 >= 48 && c1 <= 57) {
                        sb.append((char)c);
                    }
                    sb.append((char)c1);
                    continue block4;
                }
            }
            if (c == pTerminator) {
                return (char)pTerminator + sb.toString() + (char)pTerminator;
            }
            sb.append((char)c);
        }
    }

    private String processParameters(String pStatement, String[] pArgs) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pStatement.length(); ++i) {
            char c = pStatement.charAt(i);
            if (c == '\\' && i < pStatement.length() - 1) {
                char c1 = pStatement.charAt(i + 1);
                if (c1 >= '0' && c1 <= '9') {
                    int num = c1 - 48;
                    if (num >= pArgs.length) {
                        throw new IllegalStateException(this.lcr.format("Invalid parameter reference \\" + num));
                    }
                    sb.append(pArgs[num]);
                    ++i;
                    continue;
                }
                ((PushbackReader)this.in).unread(c1);
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String unEscape(String pValue) {
        char c;
        if (pValue.length() > 2 && ((c = pValue.charAt(0)) == '\'' || c == '\"') && pValue.charAt(pValue.length() - 1) == c) {
            return pValue.substring(1, pValue.length() - 1);
        }
        return pValue;
    }

    private void processMacro(List<String> pArgs) throws IOException {
        if (pArgs.size() == 0) {
            throw new IllegalStateException(this.lcr.format("Invalid macro call: Missing macro name"));
        }
        String macroName = pArgs.remove(0);
        if ("macro".equals(macroName)) {
            if (pArgs.size() == 0) {
                throw new IllegalStateException(this.lcr.format("Invalid macro specification: Missing macro name"));
            }
            String newMacroName = pArgs.remove(0);
            if (this.macros.containsKey(newMacroName)) {
                throw new IllegalStateException(this.lcr.format("Macro redefined: " + newMacroName));
            }
            for (int i = 0; i < pArgs.size(); ++i) {
                pArgs.set(i, this.unEscape(pArgs.get(i)));
            }
            String[] args = pArgs.toArray(new String[pArgs.size()]);
            this.macros.put(newMacroName, args);
        } else {
            String[] statements = this.macros.get(macroName);
            if (statements == null) {
                throw new IllegalStateException(this.lcr.format("Unknown macro: " + macroName));
            }
            String[] args = pArgs.toArray(new String[pArgs.size()]);
            for (int i = statements.length - 1; i >= 0; --i) {
                String stmt = this.processParameters(statements[i], args);
                ((PushbackReader)this.in).unread((stmt + ";\n").toCharArray());
            }
        }
    }

    private void processMacro() throws IOException {
        ArrayList<String> parameters = new ArrayList<String>();
        boolean commaExpected = false;
        block5: while (true) {
            int c;
            if (Character.isWhitespace(c = super.read())) {
                continue;
            }
            switch (c) {
                case 125: {
                    this.processMacro(parameters);
                    return;
                }
                case 44: {
                    if (!commaExpected) {
                        throw new IllegalStateException(this.lcr.format("Unexpected comma in input stream."));
                    }
                    commaExpected = false;
                    continue block5;
                }
                case 34: 
                case 39: {
                    if (commaExpected) {
                        throw new IllegalStateException(this.lcr.format("Expected comma, got parameter in input stream."));
                    }
                    parameters.add(this.processEscapedParameter(c));
                    commaExpected = true;
                    continue block5;
                }
            }
            if (commaExpected) {
                throw new IllegalStateException(this.lcr.format("Expected comma, got parameter in input stream."));
            }
            ((PushbackReader)this.in).unread(c);
            parameters.add(this.processUnescapedParameter());
            commaExpected = true;
        }
    }

    @Override
    public int read(char[] pCbuf, int pOff, int pLen) throws IOException {
        int num = 0;
        int len = pLen;
        while (len-- > 0) {
            int c = this.read();
            if (c == -1) {
                return num == 0 ? -1 : num;
            }
            pCbuf[pOff + num] = (char)c;
            ++num;
        }
        return num;
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res == 38) {
            int c = super.read();
            if (c == 123) {
                this.processMacro();
                return this.read();
            }
            ((PushbackReader)this.in).unread(c);
        }
        return res;
    }

    private static class LineCountingReader
    extends FilterReader {
        private int lineNum;
        private int colNum;

        protected LineCountingReader(Reader pIn) {
            super(pIn);
        }

        @Override
        public int read(char[] pCbuf, int pOff, int pLen) throws IOException {
            int num = 0;
            int len = pLen;
            while (len-- > 0) {
                int c = this.read();
                if (c == -1) {
                    return num == 0 ? -1 : num;
                }
                pCbuf[pOff + num] = (char)c;
                ++num;
            }
            return num;
        }

        @Override
        public int read() throws IOException {
            int res = super.read();
            if (res == 10) {
                ++this.lineNum;
                this.colNum = 0;
            } else {
                ++this.colNum;
            }
            return res;
        }

        public String format(String pMsg) {
            return "At line " + this.lineNum + ", column " + this.colNum + ": " + pMsg;
        }
    }
}

