/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.RegistryEntry;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Slot;
import org.apache.labs.jaxmas.registry.accessor.AssociationAccessor;
import org.apache.labs.jaxmas.registry.accessor.ClassificationAccessor;
import org.apache.labs.jaxmas.registry.infomodel.AssociationImpl;
import org.apache.labs.jaxmas.registry.infomodel.ClassificationImpl;
import org.apache.labs.jaxmas.registry.infomodel.ConceptImpl;
import org.apache.labs.jaxmas.registry.infomodel.InternationalStringController;
import org.apache.labs.jaxmas.registry.infomodel.InternationalStringImpl;
import org.apache.labs.jaxmas.registry.infomodel.LocalizedStringImpl;
import org.apache.labs.jaxmas.registry.infomodel.OwnedRegistryObject;
import org.apache.labs.jaxmas.registry.infomodel.ROState;
import org.apache.labs.jaxmas.registry.infomodel.RegistryEntryImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryObjectImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.infomodel.SlotImpl;
import org.apache.labs.jaxmas.registry.sql.ConnUser;
import org.apache.labs.jaxmas.registry.sql.DbDriver;
import org.apache.labs.jaxmas.registry.sql.ObjQueryUser;
import org.apache.labs.jaxmas.registry.sql.ObjStmtUser;
import org.apache.labs.jaxmas.registry.sql.QueryUser;
import org.apache.labs.jaxmas.registry.sql.Sql;
import org.apache.labs.jaxmas.registry.util.Locales;
import org.apache.log4j.Logger;

public abstract class AbstractDbDriver
implements DbDriver {
    private static final Logger log = Logger.getLogger(AbstractDbDriver.class);
    private final RegistryService registryService;

    protected AbstractDbDriver(RegistryService pRegistryService) {
        this.registryService = pRegistryService;
    }

    protected RegistryService getRegistryService() {
        return this.registryService;
    }

    protected void run(String pStmt, Object ... pParams) throws JAXRException {
        Sql.run(this.getRegistryService(), pStmt, pParams);
    }

    protected void run(ConnUser<?> pConnUser) throws JAXRException {
        pConnUser.run(this.getRegistryService());
    }

    @Override
    public long newId(String pName) throws JAXRException {
        this.run("UPDATE ids SET nextValue = nextValue + 1 WHERE name = ?", pName);
        QueryUser<Long> query = new QueryUser<Long>("SELECT nextValue FROM ids WHERE name = ?", new Object[]{pName}){

            @Override
            protected void action(ResultSet pResultSet) throws JAXRException, SQLException {
                boolean hasNext = pResultSet.next();
                assert (hasNext);
                long l = pResultSet.getLong(1);
                assert (!pResultSet.wasNull());
                hasNext = pResultSet.next();
                assert (!hasNext);
                this.setResult(new Long(l));
                if (pResultSet.next()) {
                    throw new JAXRException("Unexpected result row");
                }
            }

            @Override
            protected void action(Connection pConnection) throws JAXRException, SQLException {
                super.action(pConnection);
            }
        };
        query.run(this.getRegistryService());
        return (Long)query.getResult();
    }

    @Override
    public void deleteSlots(RegistryObject pRegistryObject) throws JAXRException {
    }

    private void saveSlots(final RegistryObjectImpl<?> pRegistryObject) throws JAXRException {
        if (!pRegistryObject.hasSlotsLoaded()) {
            return;
        }
        new ObjStmtUser("DELETE FROM RegistryObjectSlots WHERE roKey=?", new Object[]{pRegistryObject.getKey()}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void action(PreparedStatement pStatement) throws JAXRException, SQLException {
                pStatement.executeUpdate();
                Collection<?> slots = pRegistryObject.getSlots();
                if (slots != null && slots.size() > 0) {
                    String q = "INSERT INTO RegistryObjectSlots (roKey, id, name, slotType) VALUES (?, ?, ?, ?)";
                    String q2 = "INSERT INTO RegistryObjectSlotValues (id, val) VALUES (?, ?)";
                    PreparedStatement stmt = pStatement.getConnection().prepareStatement("INSERT INTO RegistryObjectSlots (roKey, id, name, slotType) VALUES (?, ?, ?, ?)");
                    Statement stmt2 = null;
                    try {
                        stmt.setString(1, pRegistryObject.getKey().getId());
                        for (Object o : slots) {
                            Slot slot = (Slot)o;
                            long id = AbstractDbDriver.this.newId("Slots");
                            stmt.setLong(2, id);
                            stmt.setString(3, slot.getName());
                            stmt.setString(4, slot.getSlotType());
                            log.debug((Object)("INSERT INTO RegistryObjectSlots (roKey, id, name, slotType) VALUES (?, ?, ?, ?), " + id + ", " + slot.getName() + ", " + slot.getSlotType()));
                            stmt.executeUpdate();
                            for (Object v : slot.getValues()) {
                                if (stmt2 == null) {
                                    stmt2 = pStatement.getConnection().prepareStatement("INSERT INTO RegistryObjectSlotValues (id, val) VALUES (?, ?)");
                                }
                                stmt2.setLong(1, id);
                                stmt2.setString(2, v == null ? null : v.toString());
                                log.debug((Object)("INSERT INTO RegistryObjectSlotValues (id, val) VALUES (?, ?), " + id + ", " + v));
                                stmt2.executeUpdate();
                            }
                        }
                        if (stmt2 != null) {
                            stmt2.close();
                            stmt2 = null;
                        }
                        stmt.close();
                        stmt = null;
                    }
                    finally {
                        if (stmt2 != null) {
                            try {
                                stmt2.close();
                            }
                            catch (Throwable t) {}
                        }
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable t) {}
                        }
                    }
                }
            }
        }.run(this.getRegistryService());
    }

    private static Collection<String> asStringCollection(Collection<?> pCollection) {
        return pCollection;
    }

    @Override
    public Map<String, Slot> getSlots(RegistryObject pRegistryObject) throws JAXRException {
        final HashMap slots = new HashMap();
        String q1 = "SELECT id, name, slotType FROM RegistryObjectSlots WHERE roKey=?";
        new ObjQueryUser("SELECT id, name, slotType FROM RegistryObjectSlots WHERE roKey=?", new Object[]{pRegistryObject.getKey()}){

            @Override
            protected void action(ResultSet pResultSet) throws JAXRException, SQLException {
                while (pResultSet.next()) {
                    Long id = new Long(pResultSet.getLong(1));
                    assert (!pResultSet.wasNull());
                    Slot slot = (Slot)slots.get(id);
                    if (slot != null) continue;
                    slot = new SlotImpl();
                    slots.put(id, slot);
                    slot.setName(pResultSet.getString(2));
                    assert (slot.getName() != null);
                    slot.setSlotType(pResultSet.getString(3));
                    slot.setValues(new ArrayList());
                }
            }
        }.run(this.getRegistryService());
        String q2 = "SELECT ros.id, rosv.val FROM RegistryObjectSlots ros JOIN RegistryObjectSlotValues rosv ON ros.id=rosv.id WHERE ros.roKey=?";
        new ObjQueryUser("SELECT ros.id, rosv.val FROM RegistryObjectSlots ros JOIN RegistryObjectSlotValues rosv ON ros.id=rosv.id WHERE ros.roKey=?", new Object[]{pRegistryObject.getKey()}){

            @Override
            protected void action(ResultSet pResultSet) throws JAXRException, SQLException {
                while (pResultSet.next()) {
                    Long id = new Long(pResultSet.getLong(1));
                    assert (!pResultSet.wasNull());
                    Slot slot = (Slot)slots.get(id);
                    assert (slot != null);
                    AbstractDbDriver.asStringCollection(slot.getValues()).add(pResultSet.getString(2));
                }
            }
        }.run(this.getRegistryService());
        HashMap<String, Slot> result = new HashMap<String, Slot>();
        for (Slot slot : slots.values()) {
            result.put(slot.getName(), slot);
        }
        return result;
    }

    @Override
    public void deleteInternationalString(Key pKey, InternationalStringImpl.Type pType) throws JAXRException {
        this.run("DELETE FROM LocalizedStrings WHERE roKey=? AND lsType=?", new Object[]{pKey, pType});
    }

    @Override
    public void updateInternationalString(Key pKey, InternationalStringImpl.Type pType, InternationalString pValue) throws JAXRException {
        this.deleteInternationalString(pKey, pType);
        this.insertInternationalString(pKey, pType, pValue);
    }

    @Override
    public void insertInternationalString(final Key pKey, final InternationalStringImpl.Type pType, final InternationalString pValue) throws JAXRException {
        if (pValue != null) {
            new ObjStmtUser("INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES (?, ?, ?, ?, ?)"){

                @Override
                protected void action(PreparedStatement pStatement) throws JAXRException, SQLException {
                    pStatement.setString(1, pKey.getId());
                    pStatement.setInt(2, pType.ordinal());
                    for (Object o : pValue.getLocalizedStrings()) {
                        LocalizedString ls = (LocalizedString)o;
                        pStatement.setString(3, ls.getLocale().toString());
                        pStatement.setString(4, ls.getCharsetName());
                        pStatement.setString(5, ls.getValue());
                        pStatement.executeUpdate();
                    }
                }
            }.run(this.getRegistryService());
        }
    }

    private static final Collection<Classification> asClassificationCollection(Collection<?> pCollection) {
        return pCollection;
    }

    private static final Collection<Association> asAssociationCollection(Collection<?> pCollection) {
        return pCollection;
    }

    @Override
    public void insert(RegistryObject pObject, int pRegistryObjectType) throws JAXRException {
        Integer pos;
        Key ownerRestricting;
        Key ownerCascading;
        RegistryObjectImpl ro = (RegistryObjectImpl)pObject;
        assert (ro.getState() == ROState.created);
        Key key = pObject.getKey();
        if (ro instanceof OwnedRegistryObject) {
            Key owner;
            OwnedRegistryObject oro = (OwnedRegistryObject)ro;
            RegistryObject roOwner = oro.getOwner();
            Key key2 = owner = roOwner == null ? null : roOwner.getKey();
            if (oro.isRestricting()) {
                ownerCascading = null;
                ownerRestricting = owner;
            } else {
                ownerCascading = owner;
                ownerRestricting = null;
            }
            pos = oro.getPosition();
        } else {
            ownerCascading = null;
            ownerRestricting = null;
            pos = null;
        }
        String s = "INSERT INTO RegistryObjects (roKey, roType, pos, roOwnerRestricting, roOwnerCascading) VALUES (?, ?, ?, ?, ?)";
        this.run("INSERT INTO RegistryObjects (roKey, roType, pos, roOwnerRestricting, roOwnerCascading) VALUES (?, ?, ?, ?, ?)", key, pRegistryObjectType, pos, ownerRestricting, ownerCascading);
        InternationalStringController name = ro.getNameController();
        name.save();
        InternationalStringController description = ro.getDescriptionController();
        description.save();
        this.saveSlots(ro);
        if (pObject instanceof RegistryEntry) {
            RegistryEntryImpl re = (RegistryEntryImpl)pObject;
            this.run("INSERT INTO RegistryEntries (roKey, customType, expiration, status, stability, majorVersion, minorVersion, userVersion) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", key, re.getCustomType(), re.getExpiration(), new Integer(re.getStatus()), new Integer(re.getStability()), new Integer(re.getMajorVersion()), new Integer(re.getMinorVersion()), re.getUserVersion());
        }
        if (pObject instanceof Concept) {
            ConceptImpl concept = (ConceptImpl)pObject;
            String value = concept.getValue();
            if (value == null) {
                throw new JAXRException(RegistryServiceImpl.getNLSStrings(this.getRegistryService()).format("CONCEPT_VALUE_MISSING", new Object[0]));
            }
            this.run("INSERT INTO Concepts (roKey, value) VALUES (?, ?)", concept.getKey(), value);
        }
        if (pObject instanceof Classification) {
            ClassificationImpl cl = (ClassificationImpl)pObject;
            Concept concept = cl.getConcept();
            assert (concept != null);
            this.run("INSERT INTO Classifications (roKey, roKeyConcept, num) VALUES (?, ?, ?)", cl.getKey(), concept.getKey(), cl.getNum());
        }
        if (pObject instanceof Association) {
            AssociationImpl assoc = (AssociationImpl)pObject;
            Concept assocType = assoc.getAssociationType();
            assert (assocType != null);
            RegistryObject target = assoc.getTargetObject();
            assert (target != null);
            this.run("INSERT INTO Associations (roKey, roKeyType, roKeyTarget, num) VALUES (?, ?, ?, ?)", assoc.getKey(), assocType.getKey(), target.getKey(), assoc.getNum());
        }
        int num = 0;
        for (Classification cl : AbstractDbDriver.asClassificationCollection(ro.getClassifications())) {
            ClassificationImpl clImpl = (ClassificationImpl)cl;
            clImpl.setNum(num++);
            clImpl.getROLoader().save(this.getRegistryService(), (RegistryObject)cl);
        }
        num = 0;
        for (Association assoc : AbstractDbDriver.asAssociationCollection(ro.getAssociations())) {
            AssociationImpl assocImpl = (AssociationImpl)assoc;
            assocImpl.setNum(num++);
            assocImpl.getROLoader().save(this.getRegistryService(), (RegistryObject)assoc);
        }
    }

    @Override
    public void update(RegistryObject pObject) throws JAXRException {
        Collection<Key> loadedAssociationKeys;
        Collection<Key> loadedClassificationKeys;
        RegistryObjectImpl ro = (RegistryObjectImpl)pObject;
        String key = pObject.getKey().getId();
        InternationalStringController name = ro.getNameController();
        name.save();
        InternationalStringController description = ro.getDescriptionController();
        description.save();
        this.saveSlots(ro);
        if (pObject instanceof RegistryEntry) {
            RegistryEntryImpl re = (RegistryEntryImpl)pObject;
            this.run("UPDATE RegistryEntries SET customType=?, expiration=?, status=?, stability=?, majorVersion=?, minorVersion=?, userVersion=? WHERE roKey=?", re.getCustomType(), re.getExpiration(), new Integer(re.getStatus()), new Integer(re.getStability()), new Integer(re.getMajorVersion()), new Integer(re.getMinorVersion()), re.getUserVersion(), key);
        }
        if (pObject instanceof Concept) {
            ConceptImpl concept = (ConceptImpl)pObject;
            switch (concept.getState()) {
                case created: {
                    throw new IllegalStateException("This object must be inserted, not updated.");
                }
                case loaded: {
                    String value = concept.getValue();
                    if (value == null) {
                        throw new JAXRException(RegistryServiceImpl.getNLSStrings(this.getRegistryService()).format("CONCEPT_VALUE_MISSING", new Object[0]));
                    }
                    this.run("UPDATE Concepts SET value=? WHERE roKey=?", value, concept.getKey());
                    break;
                }
                case referenced: {
                    break;
                }
                case deleted: {
                    throw new IllegalStateException("A deleted object cannot be updated.");
                }
            }
        }
        if (pObject instanceof Classification) {
            ClassificationImpl cl = (ClassificationImpl)pObject;
            Concept concept = cl.getConcept();
            assert (concept != null);
            this.run("UPDATE Classifications SET roKeyConcept=?, num=? WHERE roKey=?", concept.getKey(), cl.getNum(), cl.getKey());
        }
        if (pObject instanceof Association) {
            AssociationImpl assoc = (AssociationImpl)pObject;
            Concept assocType = assoc.getAssociationType();
            assert (assocType != null);
            RegistryObject target = assoc.getTargetObject();
            assert (target != null);
            this.run("UPDATE Associations SET roKeyType=?, roKeyTarget=?, num=? WHERE roKey=?", assocType.getKey(), target.getKey(), assoc.getNum(), assoc.getKey());
        }
        if ((loadedClassificationKeys = ro.getLoadedClassificationKeys()) != null) {
            HashSet<Key> currentClassificationKeys = new HashSet<Key>();
            for (Classification cl : AbstractDbDriver.asClassificationCollection(ro.getClassifications())) {
                ClassificationAccessor.getInstance().save(this.getRegistryService(), (RegistryObject)cl);
                currentClassificationKeys.add(cl.getKey());
                loadedClassificationKeys.remove(cl.getKey());
            }
            ro.setLoadedClassificationKeys(currentClassificationKeys);
            for (Key k : loadedClassificationKeys) {
                this.deleteRegistryObject(k);
            }
        }
        if ((loadedAssociationKeys = ro.getLoadedAssociationKeys()) != null) {
            HashSet<Key> currentAssociationKeys = new HashSet<Key>();
            for (Association assoc : AbstractDbDriver.asAssociationCollection(ro.getAssociations())) {
                AssociationAccessor.getInstance().save(this.getRegistryService(), (RegistryObject)assoc);
                currentAssociationKeys.add(assoc.getKey());
                loadedAssociationKeys.remove(assoc.getKey());
            }
            ro.setLoadedAssociationKeys(currentAssociationKeys);
            for (Key k : loadedAssociationKeys) {
                this.deleteRegistryObject(k);
            }
        }
    }

    @Override
    public InternationalString loadInternationalString(Key pKey, InternationalStringImpl.Type pType) throws JAXRException {
        final InternationalStringImpl is = new InternationalStringImpl();
        new ObjQueryUser("SELECT locale, charset, val FROM LocalizedStrings WHERE roKey=? AND lsType=?", new Object[]{pKey, pType}){

            @Override
            protected void action(ResultSet pResultSet) throws JAXRException, SQLException {
                while (pResultSet.next()) {
                    Locale locale = Locales.getLocale(pResultSet.getString(1));
                    String charset = pResultSet.getString(2);
                    String val = pResultSet.getString(3);
                    LocalizedStringImpl ls = new LocalizedStringImpl();
                    ls.setLocale(locale);
                    ls.setCharsetName(charset);
                    ls.setValue(val);
                    is.addLocalizedString((LocalizedString)ls);
                }
            }
        }.run(this.getRegistryService());
        return is;
    }

    @Override
    public void deleteRegistryObject(Key pKey) throws JAXRException {
        Sql.run(this.getRegistryService(), "DELETE FROM RegistryObjects WHERE roKey=?", pKey);
    }

    @Override
    public int getSchemaVersion() throws JAXRException {
        String s = "SELECT version FROM DbInfo";
        try {
            return Sql.intQuery(this.getRegistryService(), "SELECT version FROM DbInfo", new Object[0]);
        }
        catch (JAXRException e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof SQLException && this.isUnknownTableError((SQLException)t)) {
                return 0;
            }
            throw e;
        }
    }
}

