/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.util.DefaultLoggerFactory;
import org.apache.labs.jaxmas.registry.util.Logger;

public abstract class ConnUser<O> {
    private static final Logger log = DefaultLoggerFactory.getInstance().newLogger(ConnUser.class);
    private O result;

    protected void setResult(O pResult) {
        this.result = pResult;
    }

    public O getResult() {
        return this.result;
    }

    protected abstract void action(Connection var1) throws JAXRException, SQLException;

    public void run(RegistryService pRegistryService) throws JAXRException {
        this.run(((RegistryServiceImpl)pRegistryService).getConnection().getConnection());
    }

    protected void logEntering(Logger pLog, String pName) {
        pLog.entering(pName);
    }

    protected void logExiting(Logger pLog, String pName) {
        pLog.exiting(pName);
    }

    protected void logExiting(Logger pLog, String pName, String pMsg) {
        pLog.exiting(pName, pMsg);
    }

    protected Long getLong(ResultSet pResultSet, int pIndex) throws SQLException {
        long l = pResultSet.getLong(pIndex);
        return pResultSet.wasNull() ? null : new Long(l);
    }

    public void run(Connection pConnection) throws JAXRException {
        String mName = "run";
        this.logEntering(log, "run");
        try {
            this.action(pConnection);
        }
        catch (SQLException e) {
            throw new JAXRException((Throwable)e);
        }
        O o = this.getResult();
        if (o == null) {
            this.logExiting(log, "run");
        } else {
            this.logExiting(log, "run", String.valueOf(o));
        }
    }
}

