/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.xml.registry.JAXRException;
import org.apache.labs.jaxmas.registry.accessor.ROAccessors;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectLoader;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectTypePredicate;

public class CustomObjectTypePredicate
extends RegistryObjectTypePredicate {
    private final String prefix;
    private final Collection<String> types;

    public CustomObjectTypePredicate(Collection<String> pTypes, String pPrefix) {
        super(ROAccessors.ObjectTypes.REGISTRY_ENTRY, pPrefix);
        if (pTypes == null || pTypes.isEmpty()) {
            throw new IllegalArgumentException("The list of custom object types must not be null.");
        }
        this.types = pTypes;
        this.prefix = pPrefix;
    }

    public CustomObjectTypePredicate(Collection<String> pTypes) {
        this(pTypes, null);
    }

    public Collection<String> getTypes() {
        return this.types;
    }

    @Override
    public void add(StringBuilder pBuffer, List<Object> pParameters) throws SQLException, JAXRException {
        super.add(pBuffer, pParameters);
        String reTable = RegistryObjectLoader.getTable(this.prefix, "re");
        pBuffer.append(" AND ");
        Collection<String> customTypes = this.getTypes();
        pBuffer.append(reTable);
        pBuffer.append(".customType IN (SELECT ctro.roKey FROM RegistryObjects ctro JOIN Concepts ctco ON ctro.roType=? AND ctro.roKey=ctco.roKey WHERE ctro.roOwnerRestricting=? AND ");
        pParameters.add(new Integer(ROAccessors.ObjectTypes.CONCEPT.ordinal()));
        pParameters.add(ROAccessors.ClassificationSchemes.OBJECT_TYPE.getId());
        if (customTypes.size() == 1) {
            pBuffer.append("ctco.value=?");
            pParameters.add(customTypes.iterator().next());
        } else {
            pBuffer.append("ctco.value IN (");
            boolean first = true;
            for (String s : customTypes) {
                if (first) {
                    first = false;
                } else {
                    pBuffer.append(',');
                }
                pBuffer.append('?');
                pParameters.add(s);
            }
            pBuffer.append(')');
        }
        pBuffer.append(')');
    }
}

