/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import org.apache.labs.jaxmas.registry.infomodel.ConnectionImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.AbstractDbDriver;

public class DerbyDbDriver
extends AbstractDbDriver {
    public DerbyDbDriver(RegistryService pRegistryService) {
        super(pRegistryService);
    }

    @Override
    public void shutdown() throws JAXRException {
        try {
            Connection conn;
            ConnectionImpl connImpl;
            RegistryServiceImpl rs = (RegistryServiceImpl)this.getRegistryService();
            if (rs != null && (connImpl = rs.getConnection()) != null && (conn = connImpl.getConnection()) != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    @Override
    public boolean isUnknownTableError(SQLException pException) {
        return "42X05".equals(pException.getSQLState()) || "42Y55".equals(pException.getSQLState());
    }

    @Override
    public String getDbProperty(String pProperty) {
        if ("CLOB".equals(pProperty)) {
            return pProperty;
        }
        throw new IllegalArgumentException("Unknown property name: " + pProperty);
    }
}

