/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import org.apache.labs.jaxmas.registry.sql.AbstractDbDriver;
import org.apache.labs.jaxmas.registry.sql.Sql;

public class HsqlDbDriver
extends AbstractDbDriver {
    public HsqlDbDriver(RegistryService pRegistryService) {
        super(pRegistryService);
    }

    @Override
    public void shutdown() throws JAXRException {
        String s = "SHUTDOWN";
        Sql.run(this.getRegistryService(), "SHUTDOWN", new Object[0]);
    }

    @Override
    public boolean isUnknownTableError(SQLException pException) {
        if ("S0002".equals(pException.getSQLState()) && pException.getErrorCode() == -22) {
            return true;
        }
        if ("S1000".equals(pException.getSQLState()) && pException.getErrorCode() == -35) {
            return true;
        }
        return "42501".equals(pException.getSQLState()) && pException.getErrorCode() == -5501;
    }

    @Override
    public String getDbProperty(String pProperty) {
        if ("CLOB".equals(pProperty)) {
            return "LONGVARCHAR";
        }
        throw new IllegalArgumentException("Unknown property name: " + pProperty);
    }
}

