/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.xml.registry.JAXRException;
import org.apache.labs.jaxmas.registry.infomodel.InternationalStringImpl;
import org.apache.labs.jaxmas.registry.sql.FilterPredicate;

public class NamePredicate
implements FilterPredicate {
    private final Collection<String> namePatterns;

    public NamePredicate(Collection<String> pNamePatterns) {
        this.namePatterns = pNamePatterns;
    }

    @Override
    public void add(StringBuilder pBuffer, List<Object> pParameters) throws SQLException, JAXRException {
        if (this.namePatterns == null || this.namePatterns.size() == 0) {
            pBuffer.append("1=1");
            return;
        }
        pBuffer.append("ro.roKey IN (SELECT roKey FROM LocalizedStrings WHERE lsType=");
        pBuffer.append(InternationalStringImpl.Type.name.ordinal());
        if (pParameters.size() == 1) {
            pBuffer.append(" AND val LIKE ?");
            pParameters.add(this.namePatterns.iterator().next());
        } else {
            pBuffer.append(" AND (");
            boolean first = true;
            for (String namePattern : this.namePatterns) {
                if (first) {
                    first = false;
                } else {
                    pBuffer.append(" OR ");
                }
                pBuffer.append("val LIKE ?");
                pParameters.add(namePattern);
            }
            pBuffer.append(")");
        }
        pBuffer.append(")");
    }
}

