/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryEntry;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessors;
import org.apache.labs.jaxmas.registry.infomodel.AssociationImpl;
import org.apache.labs.jaxmas.registry.infomodel.ClassificationImpl;
import org.apache.labs.jaxmas.registry.infomodel.KeyImpl;
import org.apache.labs.jaxmas.registry.infomodel.OwnedRegistryObject;
import org.apache.labs.jaxmas.registry.infomodel.ROState;
import org.apache.labs.jaxmas.registry.infomodel.RegistryEntryImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryObjectImpl;
import org.apache.labs.jaxmas.registry.sql.CustomObjectTypePredicate;
import org.apache.labs.jaxmas.registry.sql.FilterPredicate;
import org.apache.labs.jaxmas.registry.sql.KeyPredicate;
import org.apache.labs.jaxmas.registry.sql.ObjQueryUser;
import org.apache.labs.jaxmas.registry.sql.OrderPredicate;
import org.apache.labs.jaxmas.registry.sql.QueryUser;
import org.apache.labs.jaxmas.registry.sql.TableHandler;

public class RegistryObjectLoader {
    private static final TableHandler[] EXTENSION_HANDLERS_REGISTRY_OBJECT = new TableHandler[]{new DefaultTableHandler()};
    private static final TableHandler[] EXTENSION_HANDLERS_ASSOCIATION = new TableHandler[]{new DefaultTableHandler(), new AssociationTableHandler(ROAccessors.ObjectTypes.ASSOCIATION)};
    private static final TableHandler[] EXTENSION_HANDLERS_CLASSIFICATION = new TableHandler[]{new DefaultTableHandler(), new ClassificationTableHandler(ROAccessors.ObjectTypes.CLASSIFICATION)};
    private static final TableHandler[] EXTENSION_HANDLERS_EXTRINSIC_OBJECT = new TableHandler[]{new DefaultTableHandler(), new RegistryEntryTableHandler(ROAccessors.ObjectTypes.EXTRINSIC_OBJECT)};
    private static final TableHandler[] EXTENSION_HANDLERS_SERVICE = new TableHandler[]{new DefaultTableHandler(), new RegistryEntryTableHandler(ROAccessors.ObjectTypes.SERVICE)};
    private static final TableHandler[] EXTENSION_HANDLERS_REGISTRY_PACKAGE = new TableHandler[]{new DefaultTableHandler(), new RegistryEntryTableHandler(ROAccessors.ObjectTypes.REGISTRY_PACKAGE)};
    private static final TableHandler[] EXTENSION_HANDLERS_REGISTRY_ENTRY = new TableHandler[]{new DefaultTableHandler(), new RegistryEntryTableHandler(ROAccessors.ObjectTypes.REGISTRY_ENTRY)};
    private static final TableHandler[] EXTENSION_HANDLERS_CLASSIFICATION_SCHEME = new TableHandler[]{new DefaultTableHandler(), new RegistryEntryTableHandler(ROAccessors.ObjectTypes.CLASSIFICATION_SCHEME)};
    private static final TableHandler[] EXTENSION_HANDLERS_CONCEPT = new TableHandler[]{new DefaultTableHandler(), new ConceptTableHandler(ROAccessors.ObjectTypes.CONCEPT)};
    private static final TableHandler[] EXTENSION_HANDLERS_NULL_TYPE = new TableHandler[]{new DefaultTableHandler(), new ConceptTableHandler(null), new RegistryEntryTableHandler(null), new AssociationTableHandler(null), new ClassificationTableHandler(null)};
    private final String query;
    private final Object[] parameters;
    private final RegistryObjectQuery[] queries;
    private String sep = " WHERE ";

    public static RegistryObjectQuery getRegistryObjectQuery(String pQName, String pPrefix) {
        ROAccessors.ObjectTypes registryObjectType = null;
        Set<CustomObjectTypePredicate> predicates = null;
        if (pQName != null) {
            for (ROAccessors.ObjectTypes objectType : ROAccessors.ObjectTypes.values()) {
                if (!objectType.getInterfaceName().equals(pQName)) continue;
                registryObjectType = objectType;
                break;
            }
            if (registryObjectType == null) {
                registryObjectType = ROAccessors.ObjectTypes.REGISTRY_ENTRY;
                Set<String> objectTypes = Collections.singleton(pQName);
                predicates = Collections.singleton(new CustomObjectTypePredicate(objectTypes, pPrefix));
            }
        }
        return new RegistryObjectQuery(registryObjectType, pPrefix, predicates);
    }

    private static TableHandler[] getExtensionHandlers(ROAccessors.ObjectTypes pObjectType) {
        if (pObjectType == null) {
            return EXTENSION_HANDLERS_NULL_TYPE;
        }
        switch (pObjectType) {
            case CONCEPT: {
                return EXTENSION_HANDLERS_CONCEPT;
            }
            case CLASSIFICATION_SCHEME: {
                return EXTENSION_HANDLERS_CLASSIFICATION_SCHEME;
            }
            case REGISTRY_ENTRY: {
                return EXTENSION_HANDLERS_REGISTRY_ENTRY;
            }
            case REGISTRY_PACKAGE: {
                return EXTENSION_HANDLERS_REGISTRY_PACKAGE;
            }
            case SERVICE: {
                return EXTENSION_HANDLERS_SERVICE;
            }
            case EXTRINSIC_OBJECT: {
                return EXTENSION_HANDLERS_EXTRINSIC_OBJECT;
            }
            case CLASSIFICATION: {
                return EXTENSION_HANDLERS_CLASSIFICATION;
            }
            case ASSOCIATION: {
                return EXTENSION_HANDLERS_ASSOCIATION;
            }
            case AUDITABLE_EVENT: 
            case EXTERNAL_IDENTIFIER: 
            case EXTERNAL_LINK: 
            case ORGANIZATION: 
            case SERVICE_BINDING: 
            case SPECIFICATION_LINK: 
            case USER: {
                return EXTENSION_HANDLERS_REGISTRY_OBJECT;
            }
        }
        return null;
    }

    public static String getAliasAssociations(RegistryObjectQuery pSource) {
        return RegistryObjectLoader.getTable(pSource.getPrefix(), "assoc");
    }

    public static String getAliasRegistryObjects(RegistryObjectQuery pSource) {
        return RegistryObjectLoader.getTable(pSource.getPrefix(), "ro");
    }

    public static String getAliasRegistryEntries(RegistryObjectQuery pSource) {
        return RegistryObjectLoader.getTable(pSource.getPrefix(), "re");
    }

    public static String getAliasSlots(RegistryObjectQuery pSource) {
        return RegistryObjectLoader.getTable(pSource.getPrefix(), "ros");
    }

    public static String getAliasSlotValues(RegistryObjectQuery pSource) {
        return RegistryObjectLoader.getTable(pSource.getPrefix(), "rosv");
    }

    static String getTable(String pPrefix, String pSuffix) {
        if (pPrefix == null || pPrefix.length() == 0) {
            return pSuffix;
        }
        return pPrefix + pSuffix;
    }

    static String getRoTable(String pPrefix) {
        return RegistryObjectLoader.getTable(pPrefix, "ro");
    }

    public RegistryObjectLoader(RegistryObjectQuery[] pQueries, Collection<OrderPredicate> pOrderPredicates) throws JAXRException, SQLException {
        int j;
        this.queries = pQueries;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        int index = 1;
        for (int i = 0; i < this.queries.length; ++i) {
            RegistryObjectQuery q = this.queries[i];
            if (i > 0) {
                sb.append(", ");
            }
            TableHandler[] tableHandlers = q.getTableHandlers();
            index = tableHandlers[0].addColumns(sb, q.getPrefix(), index);
        }
        for (RegistryObjectQuery q : this.queries) {
            TableHandler[] tableHandlers = q.getTableHandlers();
            String prefix = q.getPrefix();
            for (j = 1; j < tableHandlers.length; ++j) {
                index = tableHandlers[j].addColumns(sb, prefix, index);
            }
        }
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (int i = 0; i < this.queries.length; ++i) {
            RegistryObjectQuery q = this.queries[i];
            String table = RegistryObjectLoader.getRoTable(q.getPrefix());
            if (i > 0) {
                sb.append(" JOIN RegistryObjects ");
                sb.append(table);
                ROAccessors.ObjectTypes objectType = q.getObjectType();
                String objectTypeSep = " ON ";
                if (objectType == null) continue;
                sb.append(objectTypeSep);
                objectTypeSep = " AND ";
                sb.append(table);
                sb.append(".roType=");
                sb.append(objectType.ordinal());
                continue;
            }
            sb.append(" FROM RegistryObjects ");
            sb.append(table);
        }
        for (RegistryObjectQuery q2 : this.queries) {
            TableHandler[] otTableHandlers = q2.getTableHandlers();
            for (j = 1; j < otTableHandlers.length; ++j) {
                otTableHandlers[j].addJoin(sb, q2.getPrefix(), parameterList);
            }
        }
        RegistryObjectQuery q = this.queries[0];
        ROAccessors.ObjectTypes objectType = q.getObjectType();
        if (objectType != null) {
            String table = RegistryObjectLoader.getRoTable(q.getPrefix());
            sb.append(this.sep);
            this.sep = " AND ";
            sb.append(table);
            sb.append(".roType=");
            sb.append(objectType.ordinal());
        }
        for (RegistryObjectQuery q2 : this.queries) {
            Collection<FilterPredicate> predicates = q2.getPredicates();
            this.appendToQuery(predicates, parameterList, this.sep, sb, true);
        }
        this.appendToQuery(pOrderPredicates, parameterList, sb);
        this.parameters = parameterList.toArray();
        this.query = sb.toString();
    }

    public RegistryObjectLoader(ROAccessors.ObjectTypes pObjectType, Collection<FilterPredicate> pFilterPredicates, Collection<OrderPredicate> pOrderPredicates) throws JAXRException, SQLException {
        this(new RegistryObjectQuery[]{new RegistryObjectQuery(pObjectType, null, pFilterPredicates)}, pOrderPredicates);
    }

    public <RO extends RegistryObject> List<RegistryObject> getResultList(RegistryService pRegistryService, Collection<FilterPredicate> pFilterPredicates, Collection<OrderPredicate> pOrderPredicates) throws JAXRException {
        if (!(pFilterPredicates != null && pFilterPredicates.size() != 0 || pOrderPredicates != null && pOrderPredicates.size() != 0)) {
            return this.getResultList(pRegistryService, this.query, this.parameters);
        }
        StringBuilder sb = new StringBuilder(this.query);
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(this.parameters));
        try {
            this.appendToQuery(pFilterPredicates, params, this.sep, sb, false);
            this.appendToQuery(pOrderPredicates, params, sb);
            return this.getResultList(pRegistryService, sb.toString(), params.toArray());
        }
        catch (SQLException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    private void appendToQuery(Collection<OrderPredicate> pPredicates, List<Object> pParams, StringBuilder sb) throws JAXRException, SQLException {
        if (pPredicates != null) {
            String mySep = " ORDER BY ";
            for (OrderPredicate predicate : pPredicates) {
                sb.append(mySep);
                mySep = ", ";
                predicate.add(sb, pParams);
            }
        }
    }

    private void appendToQuery(Collection<FilterPredicate> pPredicates, List<Object> pParams, String pSep, StringBuilder sb, boolean pModifySep) throws JAXRException, SQLException {
        if (pPredicates != null) {
            String mySep = pSep;
            for (FilterPredicate predicate : pPredicates) {
                sb.append(mySep);
                mySep = " AND ";
                if (pModifySep) {
                    this.sep = mySep;
                }
                predicate.add(sb, pParams);
            }
        }
    }

    public <RO extends RegistryObject> List<RegistryObject> getResultList(RegistryService pRegistryService) throws JAXRException {
        return this.getResultList(pRegistryService, this.query, this.parameters);
    }

    public List<RegistryObject> getResultList(RegistryService pService, PreparedStatement pStmt) throws JAXRException {
        ArrayList<RegistryObject> list = new ArrayList<RegistryObject>();
        ResultSet rs = null;
        try {
            rs = pStmt.executeQuery();
            while (rs.next()) {
                int type = rs.getInt(2);
                assert (!rs.wasNull());
                ROAccessor<?> roAcc = ROAccessors.getROAccessor(type);
                String key = rs.getString(1);
                assert (key != null);
                Object ro = roAcc.create(pService, new KeyImpl(key));
                this.load((RegistryObject)ro, rs);
                list.add((RegistryObject)ro);
            }
            rs.close();
            rs = null;
            ArrayList<RegistryObject> type = list;
            return type;
        }
        catch (SQLException e) {
            throw new JAXRException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public List<RegistryObject[]> getResultArrayList(RegistryService pService, PreparedStatement pStmt) throws JAXRException {
        ArrayList<RegistryObject[]> list = new ArrayList<RegistryObject[]>();
        ResultSet rs = null;
        try {
            Object row;
            rs = pStmt.executeQuery();
            while (rs.next()) {
                int i;
                row = new RegistryObject[this.queries.length];
                int index = 1;
                for (i = 0; i < ((RegistryObject[])row).length; ++i) {
                    int type = rs.getInt(index + 1);
                    assert (!rs.wasNull());
                    ROAccessor<?> roAcc = ROAccessors.getROAccessor(type);
                    String key = rs.getString(index + 1);
                    assert (key != null);
                    RegistryObjectImpl ro = (RegistryObjectImpl)roAcc.create(pService, new KeyImpl(key));
                    ro.setState(ROState.loaded);
                    TableHandler[] tableHandlers = this.queries[i].tableHandlers;
                    index = tableHandlers[0].load(rs, ro, index);
                    row[i] = ro;
                }
                for (i = 0; i < ((RegistryObject[])row).length; ++i) {
                    RegistryObject ro = row[i];
                    TableHandler[] tableHandlers = this.queries[i].tableHandlers;
                    for (int j = 1; j < tableHandlers.length; ++j) {
                        index = tableHandlers[j].load(rs, ro, index);
                    }
                }
                list.add((RegistryObject[])row);
            }
            rs.close();
            rs = null;
            row = list;
            return row;
        }
        catch (SQLException e) {
            throw new JAXRException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private <RO extends RegistryObject> List<RegistryObject> getResultList(final RegistryService pRegistryService, String pQuery, Object[] pParameters) throws JAXRException {
        final ArrayList<RegistryObject> list = new ArrayList<RegistryObject>();
        new ObjQueryUser(pQuery, pParameters){

            @Override
            protected void action(ResultSet pResultSet) throws JAXRException, SQLException {
                while (pResultSet.next()) {
                    int type = pResultSet.getInt(2);
                    assert (!pResultSet.wasNull());
                    ROAccessor<?> roAcc = ROAccessors.getROAccessor(type);
                    String key = pResultSet.getString(1);
                    assert (key != null);
                    Object ro = roAcc.create(pRegistryService, new KeyImpl(key));
                    RegistryObjectLoader.this.load(ro, pResultSet);
                    list.add(ro);
                }
                this.setResult(list.size());
            }
        }.run(pRegistryService);
        return list;
    }

    public <RO extends RegistryObject> RO getResultObject(RegistryService pRegistryService, Collection<FilterPredicate> pPredicates) throws JAXRException {
        RegistryObject ro;
        if (pPredicates == null || pPredicates.isEmpty()) {
            ro = this.getResultObject(pRegistryService, this.query, this.parameters);
        } else {
            StringBuilder sb = new StringBuilder(this.query);
            ArrayList<Object> params = new ArrayList<Object>();
            try {
                this.appendToQuery(pPredicates, params, this.sep, sb, false);
                ro = this.getResultObject(pRegistryService, sb.toString(), params.toArray());
            }
            catch (SQLException e) {
                throw new JAXRException((Throwable)e);
            }
        }
        return (RO)ro;
    }

    public <RO extends RegistryObject> RO getResultObject(RegistryService pRegistryService) throws JAXRException {
        RegistryObject ro = this.getResultObject(pRegistryService, this.query, this.parameters);
        return (RO)ro;
    }

    private <RO extends RegistryObject> ROAccessor<RO> asROAccessor(ROAccessor<?> pRO) {
        return pRO;
    }

    private RegistryObject getResultObject(final RegistryService pRegistryService, String pQuery, Object[] pParameters) throws JAXRException {
        QueryUser<RegistryObject> qu = new QueryUser<RegistryObject>(pQuery, pParameters){

            @Override
            protected void action(ResultSet pResultSet) throws JAXRException, SQLException {
                if (pResultSet.next()) {
                    int type = pResultSet.getInt(2);
                    assert (!pResultSet.wasNull());
                    ROAccessor roAcc = RegistryObjectLoader.this.asROAccessor(ROAccessors.getROAccessor(type));
                    String key = pResultSet.getString(1);
                    assert (key != null);
                    Object ro = roAcc.create(pRegistryService, new KeyImpl(key));
                    RegistryObjectLoader.this.load(ro, pResultSet);
                    this.setResult(ro);
                }
            }
        };
        qu.run(pRegistryService);
        return (RegistryObject)qu.getResult();
    }

    private int load(RegistryObject pRegistryObject, ResultSet pResultSet) throws SQLException, JAXRException {
        RegistryObjectImpl ro = (RegistryObjectImpl)pRegistryObject;
        ro.setState(ROState.loaded);
        TableHandler[] tableHandlers = this.queries[0].tableHandlers;
        int index = 1;
        for (int i = 0; i < tableHandlers.length; ++i) {
            index = tableHandlers[i].load(pResultSet, pRegistryObject, index);
        }
        return index;
    }

    public void load(RegistryService pRegistryService, final RegistryObject pRegistryObject) throws JAXRException {
        KeyPredicate predicate = new KeyPredicate(Collections.singleton(pRegistryObject.getKey()));
        StringBuilder sb = new StringBuilder(this.query);
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(this.parameters));
        try {
            this.appendToQuery(Collections.singleton(predicate), params, this.sep, sb, false);
        }
        catch (SQLException e) {
            throw new JAXRException((Throwable)e);
        }
        new ObjQueryUser(sb.toString(), params.toArray()){

            @Override
            protected void action(ResultSet pResultSet) throws JAXRException, SQLException {
                if (!pResultSet.next()) {
                    throw new IllegalStateException("Object not found: " + pRegistryObject.getKey());
                }
                int type = pResultSet.getInt(2);
                assert (!pResultSet.wasNull() && type == RegistryObjectLoader.this.queries[0].objectType.ordinal());
                RegistryObjectLoader.this.load(pRegistryObject, pResultSet);
                if (pResultSet.next()) {
                    throw new IllegalStateException("Multiple objects found: " + pRegistryObject.getKey());
                }
            }
        }.run(pRegistryService);
    }

    public String getQuery() {
        return this.query;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public static class RegistryObjectQuery {
        private final ROAccessors.ObjectTypes objectType;
        private final String prefix;
        private final Collection<FilterPredicate> predicates;
        private final TableHandler[] tableHandlers;

        public RegistryObjectQuery(ROAccessors.ObjectTypes pObjectType, String pPrefix, Collection<FilterPredicate> pPredicates) {
            this.objectType = pObjectType;
            this.prefix = pPrefix;
            this.predicates = pPredicates;
            this.tableHandlers = RegistryObjectLoader.getExtensionHandlers(pObjectType);
        }

        public TableHandler[] getTableHandlers() {
            return this.tableHandlers;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public ROAccessors.ObjectTypes getObjectType() {
            return this.objectType;
        }

        public Collection<FilterPredicate> getPredicates() {
            return this.predicates;
        }
    }

    public static class ClassificationTableHandler
    extends TableHandler {
        public ClassificationTableHandler(ROAccessors.ObjectTypes pObjectType) {
            super(pObjectType);
        }

        @Override
        protected int addColumns(StringBuilder pBuilder, String pPrefix, int pIndex) {
            String table = RegistryObjectLoader.getTable(pPrefix, "cl");
            pBuilder.append(", ");
            pBuilder.append(table);
            pBuilder.append(".roKeyConcept, ");
            pBuilder.append(table);
            pBuilder.append(".num");
            return pIndex + 2;
        }

        @Override
        protected void addJoin(StringBuilder pBuilder, String pPrefix, List<?> pParameters) {
            String table = RegistryObjectLoader.getTable(pPrefix, "cl");
            String roTable = RegistryObjectLoader.getRoTable(pPrefix);
            if (this.getObjectType() == null) {
                pBuilder.append(" LEFT OUTER");
            }
            pBuilder.append(" JOIN Classifications ");
            pBuilder.append(table);
            pBuilder.append(" ON ");
            pBuilder.append(roTable);
            pBuilder.append(".roType=");
            pBuilder.append(ROAccessors.ObjectTypes.CLASSIFICATION.ordinal());
            pBuilder.append(" AND ");
            pBuilder.append(roTable);
            pBuilder.append(".roKey=");
            pBuilder.append(table);
            pBuilder.append(".roKey");
        }

        @Override
        protected int load(ResultSet pResultSet, RegistryObject pRegistryObject, int pIndex) throws SQLException, JAXRException {
            if (pRegistryObject instanceof Classification) {
                ClassificationImpl cl = (ClassificationImpl)pRegistryObject;
                String conceptKey = pResultSet.getString(pIndex);
                assert (conceptKey != null);
                cl.setConceptKey(new KeyImpl(conceptKey));
                cl.setNum(pResultSet.getInt(pIndex + 1));
                assert (!pResultSet.wasNull());
            }
            return pIndex + 2;
        }
    }

    public static class AssociationTableHandler
    extends TableHandler {
        public AssociationTableHandler(ROAccessors.ObjectTypes pObjectType) {
            super(pObjectType);
        }

        @Override
        protected int addColumns(StringBuilder pBuilder, String pPrefix, int pIndex) {
            String table = RegistryObjectLoader.getTable(pPrefix, "assoc");
            pBuilder.append(", ");
            pBuilder.append(table);
            pBuilder.append(".roKeyTarget, ");
            pBuilder.append(table);
            pBuilder.append(".roKeyType, ");
            pBuilder.append(table);
            pBuilder.append(".num");
            return pIndex + 3;
        }

        @Override
        protected void addJoin(StringBuilder pBuilder, String pPrefix, List<?> pParameters) {
            String table = RegistryObjectLoader.getTable(pPrefix, "assoc");
            String roTable = RegistryObjectLoader.getRoTable(pPrefix);
            if (this.getObjectType() == null) {
                pBuilder.append(" LEFT OUTER");
            }
            pBuilder.append(" JOIN Associations ");
            pBuilder.append(table);
            pBuilder.append(" ON ");
            pBuilder.append(roTable);
            pBuilder.append(".roType=");
            pBuilder.append(ROAccessors.ObjectTypes.ASSOCIATION.ordinal());
            pBuilder.append(" AND ");
            pBuilder.append(roTable);
            pBuilder.append(".roKey=");
            pBuilder.append(table);
            pBuilder.append(".roKey");
        }

        @Override
        protected int load(ResultSet pResultSet, RegistryObject pRegistryObject, int pIndex) throws SQLException, JAXRException {
            if (pRegistryObject instanceof Association) {
                AssociationImpl assoc = (AssociationImpl)pRegistryObject;
                String targetKey = pResultSet.getString(pIndex);
                assert (targetKey != null);
                assoc.setTargetObjectKey(new KeyImpl(targetKey));
                String typeKey = pResultSet.getString(pIndex + 1);
                assert (typeKey != null);
                assoc.setAssociationTypeKey(new KeyImpl(typeKey));
                assoc.setNum(pResultSet.getInt(pIndex + 2));
                assert (!pResultSet.wasNull());
            }
            return pIndex + 3;
        }
    }

    public static class DefaultTableHandler
    extends TableHandler {
        public DefaultTableHandler() {
            super(null);
        }

        @Override
        protected int addColumns(StringBuilder pBuilder, String pPrefix, int pIndex) {
            String table = RegistryObjectLoader.getRoTable(pPrefix);
            pBuilder.append(table);
            pBuilder.append(".roKey, ");
            pBuilder.append(table);
            pBuilder.append(".roType, ");
            pBuilder.append(table);
            pBuilder.append(".roOwnerRestricting, ");
            pBuilder.append(table);
            pBuilder.append(".roOwnerCascading, ");
            pBuilder.append(table);
            pBuilder.append(".pos");
            return pIndex + 5;
        }

        @Override
        protected void addJoin(StringBuilder pBuilder, String pPrefix, List<?> pParameters) {
            throw new IllegalStateException("Join not supported");
        }

        @Override
        protected int load(ResultSet pResultSet, RegistryObject pRegistryObject, int pIndex) throws SQLException, JAXRException {
            RegistryObjectImpl ro = (RegistryObjectImpl)pRegistryObject;
            ro.setState(ROState.loaded);
            if (pRegistryObject instanceof OwnedRegistryObject) {
                String ownerKey;
                OwnedRegistryObject oro = (OwnedRegistryObject)ro;
                String ownerKeyRestricting = pResultSet.getString(pIndex + 2);
                String ownerKeyCascading = pResultSet.getString(pIndex + 3);
                assert (ownerKeyRestricting == null || ownerKeyCascading == null);
                String string = ownerKey = ownerKeyCascading == null ? ownerKeyRestricting : ownerKeyCascading;
                assert (ownerKey != null);
                oro.setOwner(new KeyImpl(ownerKey));
                int pos = pResultSet.getInt(pIndex + 4);
                assert (!pResultSet.wasNull());
                oro.setPosition(pos);
            }
            return pIndex + 5;
        }
    }

    public static class RegistryEntryTableHandler
    extends TableHandler {
        public RegistryEntryTableHandler(ROAccessors.ObjectTypes pObjectType) {
            super(pObjectType);
        }

        @Override
        protected int addColumns(StringBuilder pBuilder, String pPrefix, int pIndex) {
            String table = RegistryObjectLoader.getTable(pPrefix, "re");
            pBuilder.append(", ");
            pBuilder.append(table);
            pBuilder.append(".customType, ");
            pBuilder.append(table);
            pBuilder.append(".expiration, ");
            pBuilder.append(table);
            pBuilder.append(".status, ");
            pBuilder.append(table);
            pBuilder.append(".stability, ");
            pBuilder.append(table);
            pBuilder.append(".majorVersion, ");
            pBuilder.append(table);
            pBuilder.append(".minorVersion, ");
            pBuilder.append(table);
            pBuilder.append(".userVersion");
            return pIndex + 7;
        }

        @Override
        protected void addJoin(StringBuilder pBuilder, String pPrefix, List<?> pParameters) {
            String table = RegistryObjectLoader.getTable(pPrefix, "re");
            String roTable = RegistryObjectLoader.getRoTable(pPrefix);
            ROAccessors.ObjectTypes objectType = this.getObjectType();
            if (objectType == null) {
                pBuilder.append(" LEFT OUTER JOIN RegistryEntries ");
                pBuilder.append(table);
                pBuilder.append(" ON (");
                pBuilder.append(roTable);
                pBuilder.append(".roType=");
                pBuilder.append(ROAccessors.ObjectTypes.CLASSIFICATION_SCHEME.ordinal());
                pBuilder.append(" OR ");
                pBuilder.append(roTable);
                pBuilder.append(".roType=");
                pBuilder.append(ROAccessors.ObjectTypes.REGISTRY_ENTRY.ordinal());
                pBuilder.append(")");
            } else {
                pBuilder.append(" JOIN RegistryEntries ");
                pBuilder.append(table);
                pBuilder.append(" ON ");
                pBuilder.append(roTable);
                pBuilder.append(".roType=");
                pBuilder.append(String.valueOf(objectType.ordinal()));
            }
            pBuilder.append(" AND ");
            pBuilder.append(roTable);
            pBuilder.append(".roKey=");
            pBuilder.append(table);
            pBuilder.append(".roKey");
        }

        @Override
        protected int load(ResultSet pResultSet, RegistryObject pRegistryObject, int pIndex) throws SQLException, JAXRException {
            if (pRegistryObject instanceof RegistryEntry) {
                RegistryEntryImpl re = (RegistryEntryImpl)pRegistryObject;
                re.setCustomType(pResultSet.getString(pIndex));
                re.setExpiration(pResultSet.getDate(pIndex + 1));
                re.setStability(pResultSet.getInt(pIndex + 3));
                re.setMajorVersion(pResultSet.getInt(pIndex + 4));
                re.setMinorVersion(pResultSet.getInt(pIndex + 5));
                re.setUserVersion(pResultSet.getString(pIndex + 6));
            }
            return pIndex + 7;
        }
    }

    public static class ConceptTableHandler
    extends TableHandler {
        public ConceptTableHandler(ROAccessors.ObjectTypes pObjectType) {
            super(pObjectType);
        }

        @Override
        protected int addColumns(StringBuilder pBuilder, String pPrefix, int pIndex) {
            String table = RegistryObjectLoader.getTable(pPrefix, "c");
            pBuilder.append(", ");
            pBuilder.append(table);
            pBuilder.append(".value");
            return pIndex + 1;
        }

        @Override
        protected void addJoin(StringBuilder pBuilder, String pPrefix, List<?> pParameters) {
            String table = RegistryObjectLoader.getTable(pPrefix, "c");
            String roTable = RegistryObjectLoader.getRoTable(pPrefix);
            if (this.getObjectType() == null) {
                pBuilder.append(" LEFT OUTER");
            }
            pBuilder.append(" JOIN Concepts ");
            pBuilder.append(table);
            pBuilder.append(" ON ");
            pBuilder.append(roTable);
            pBuilder.append(".roType=");
            pBuilder.append(String.valueOf(ROAccessors.ObjectTypes.CONCEPT.ordinal()));
            pBuilder.append(" AND ");
            pBuilder.append(roTable);
            pBuilder.append(".roKey=");
            pBuilder.append(table);
            pBuilder.append(".roKey");
        }

        @Override
        protected int load(ResultSet pResultSet, RegistryObject pRegistryObject, int pIndex) throws SQLException, JAXRException {
            if (pRegistryObject instanceof Concept) {
                Concept concept = (Concept)pRegistryObject;
                concept.setValue(pResultSet.getString(pIndex));
            }
            return pIndex + 1;
        }
    }
}

