/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;
import org.apache.labs.jaxmas.registry.sql.ConnUser;
import org.apache.labs.jaxmas.registry.util.Calendars;
import org.apache.labs.jaxmas.registry.util.Logger;

public abstract class StmtUser<O>
extends ConnUser<O> {
    private final String statement;
    private Object[] params;

    public StmtUser(String pStatement, Object ... pParams) {
        this.statement = pStatement;
        this.params = pParams;
    }

    public StmtUser(String pStatement) {
        this.statement = pStatement;
        this.params = null;
    }

    protected abstract void action(PreparedStatement var1) throws JAXRException, SQLException;

    public static void setParams(PreparedStatement pStmt, Object[] pParams) throws SQLException, JAXRException {
        if (pParams != null) {
            for (int i = 0; i < pParams.length; ++i) {
                Object o = pParams[i];
                if (o == null) {
                    pStmt.setNull(i + 1, 12);
                    continue;
                }
                if (o instanceof String) {
                    pStmt.setString(i + 1, (String)o);
                    continue;
                }
                if (o instanceof Integer) {
                    pStmt.setInt(i + 1, (Integer)o);
                    continue;
                }
                if (o instanceof Long) {
                    pStmt.setLong(i + 1, (Long)o);
                    continue;
                }
                if (o instanceof Boolean) {
                    pStmt.setBoolean(i + 1, (Boolean)o);
                    continue;
                }
                if (o instanceof Short) {
                    pStmt.setShort(i + 1, (Short)o);
                    continue;
                }
                if (o instanceof Byte) {
                    pStmt.setByte(i + 1, (Byte)o);
                    continue;
                }
                if (o instanceof Float) {
                    pStmt.setFloat(i + 1, ((Float)o).floatValue());
                    continue;
                }
                if (o instanceof Double) {
                    pStmt.setDouble(i + 1, (Double)o);
                    continue;
                }
                if (o instanceof Date) {
                    Calendar cal = Calendars.nowUTC();
                    Timestamp ts = o instanceof Timestamp ? (Timestamp)o : new Timestamp(((Date)o).getTime());
                    pStmt.setTimestamp(i + 1, ts, cal);
                    continue;
                }
                if (o instanceof Key) {
                    pStmt.setString(i + 1, ((Key)o).getId());
                    continue;
                }
                if (o instanceof Enum) {
                    pStmt.setInt(i + 1, ((Enum)o).ordinal());
                    continue;
                }
                throw new IllegalStateException("Invalid parameter type: " + o.getClass().getName());
            }
        }
    }

    protected Object[] getParams() {
        return this.params;
    }

    @Override
    protected void logEntering(Logger pLog, String pName) {
        if (pLog.isDebugEnabled()) {
            pLog.entering(pName, this.statement, this.getParams());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void action(Connection pConnection) throws JAXRException, SQLException {
        PreparedStatement stmt = pConnection.prepareStatement(this.statement);
        try {
            StmtUser.setParams(stmt, this.getParams());
            this.action(stmt);
            stmt.close();
            stmt = null;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

